/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.dao.hibernate;

import gov.va.med.hds.hdr.common.hibernate.LifecycleAwareHibernateSession;
import gov.va.med.hds.hdr.common.hibernate.LifecycleAwareHibernateTransaction;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.session.ImsSession;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public abstract class HibernateDAO {
    protected SessionFactory sessionFactory;

    public HibernateDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected synchronized Session getHibernateSession() throws DataAccessException {
        Session session = null;
        try {
            ImsSession imsSession = ServiceLocator.getInstance().getImsSession();
            session = (Session)imsSession.getAttribute("hibernate.session");
            if (session == null) {
                session = this.sessionFactory.openSession();
                imsSession.setAttribute("hibernate.session", new LifecycleAwareHibernateSession(session));
            }
        }
        catch (Exception e) {
            throw new DataAccessException("Error creating or getting hibernate session object.", e);
        }
        return session;
    }

    protected synchronized void beginTransaction() throws DataAccessException {
        try {
            ImsSession imsSession = ServiceLocator.getInstance().getImsSession();
            Transaction txn = (Transaction)imsSession.getAttribute("hibernate.transaction");
            if (txn == null) {
                Session session = this.getHibernateSession();
                txn = new LifecycleAwareHibernateTransaction(session.beginTransaction());
                imsSession.setAttribute("hibernate.transaction", txn);
            }
        }
        catch (Exception e) {
            throw new DataAccessException("Error starting new tranaction.", e);
        }
    }
}

