/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.dao.hibernate;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import java.io.File;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateConfigure
extends Configuration {
    private static HibernateConfigure instance = null;
    private static SessionFactory sessions = null;
    private static PropertyMgr pm = PropertyMgr.getInstance();

    private HibernateConfigure() throws DataAccessException {
    }

    public static final HibernateConfigure getInstance() throws Exception {
        HibernateConfigure.configureDAO();
        return instance;
    }

    public static void configureDAO() throws Exception {
        if (instance == null) {
            instance = new HibernateConfigure();
            sessions = null;
            PropertyElement hibernatePropertyLocator = pm.getProperty("objectpersist/hibernate-configuration/session-factory");
            PropertyElement[] hibernateProperties = hibernatePropertyLocator.getChildProperties();
            String hbrntSessionName = hibernatePropertyLocator.getAttribute("name");
            Properties hbrntProperties = new Properties();
            for (int i = 0; i < hibernateProperties.length; ++i) {
                hbrntProperties.setProperty(hibernateProperties[i].getAttribute("name"), hibernateProperties[i].getAttribute("value"));
            }
            try {
                Configuration cfg = new Configuration();
                cfg.addDirectory(new File("gov/va/med/hds/hdr/busobj/vhim/lab"));
                cfg.setProperties(System.getProperties());
                cfg.addProperties(hbrntProperties);
                sessions = cfg.buildSessionFactory();
            }
            catch (Exception ex) {
                IMSException.getIMSException("Error writing data object to HL7 message log table.", ex);
                throw new Exception("Configuation set failed", ex);
            }
        }
    }

    public SessionFactory getSessionFactory() {
        return sessions;
    }
}

