/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.dao;

import gov.va.med.hds.hdr.service.Service;
import gov.va.med.hds.hdr.service.ServiceException;
import gov.va.med.hds.hdr.service.ServiceFactory;
import gov.va.med.hds.hdr.service.ServiceUnavailableException;
import gov.va.med.hds.hdr.service.dao.DAOFactory;
import gov.va.med.hds.hdr.service.dao.DAOFactoryCreationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class MappedDAOFactoryFactory
implements ServiceFactory,
Service {
    private static MappedDAOFactoryFactory instance = null;
    private static Map<String, DAOFactory> templateToDAOFactoryMap = new Hashtable<String, DAOFactory>();

    public Service createService(Properties properties) throws ServiceException {
        Enumeration<Object> e = properties.keys();
        DAOFactory factory = null;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String className = properties.getProperty(name);
            try {
                factory = (DAOFactory)Class.forName(className).newInstance();
            }
            catch (Exception e1) {
                throw new DAOFactoryCreationException("An error occurred while creating the DAO factory of type: \n" + className + ".", e1);
            }
            templateToDAOFactoryMap.put(name, factory);
        }
        return this;
    }

    public DAOFactory getFactory(String key) throws ServiceUnavailableException {
        DAOFactory factory = templateToDAOFactoryMap.get(key = key == null ? "" : key);
        if (factory != null) {
            return factory;
        }
        throw new ServiceUnavailableException("There is no DAO factory associated with the key '" + key + "' in the map.");
    }
}

