/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.adtprocess;

import gov.va.med.hds.hdr.busobj.domain.CorrelatingDataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocator;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocatorException;
import gov.va.med.hds.hdr.busobj.domain.PatientOperationsDomain;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.patient.PatientRecord;
import gov.va.med.hds.hdr.service.adtprocess.AdtProcess;
import gov.va.med.hds.hdr.service.adtprocess.AdtProcessException;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.XMLDocumentA24MessageMetaData;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.XMLDocumentA43MessageMetaData;

public class AdtProcessImpl
implements AdtProcess {
    private static final String ICN_DATA_DOMAIN = "FHIE.GOV/VA0";
    private String originatingDomain;

    public AdtProcessImpl(String originatingDomain) {
        this.setOriginatingDomain(originatingDomain);
    }

    public boolean doLinkOperation(XMLDocumentA24MessageMetaData metaData) throws AdtProcessException {
        DataDomain dataDomain;
        boolean retVal = false;
        String toicn = metaData.getToICN();
        String fromicn = metaData.getFromICN();
        try {
            if (!this.validAdtA24Message(metaData)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            if (toicn == null) {
                throw new AdtProcessException("from ICN is missing:  " + fromicn, e);
            }
            if (fromicn == null) {
                throw new AdtProcessException("from ICN is missing:  " + toicn, e);
            }
            throw new AdtProcessException("An error occurred trying to validate the structure of the ADT A24", e);
        }
        try {
            dataDomain = DataDomainLocator.getInstance().locate(this.originatingDomain);
        }
        catch (DataDomainLocatorException e1) {
            throw new AdtProcessException("An error occurred while trying to locate the DataDomain object for the domain: " + this.originatingDomain + ".", e1);
        }
        try {
            PatientOperationsDomain patientOperations = new PatientOperationsDomain(this.originatingDomain);
            PatientRecord toPatient = new PatientRecord(1, metaData.getToLocalId(), metaData.getToPidDomain(), metaData.getToLNM(), metaData.getToFNM(), metaData.getToMNM(), null, metaData.getToSSN(), metaData.getToDOB(), metaData.getToICN());
            PatientRecord fromPatient = new PatientRecord(2, metaData.getFromLocalId(), metaData.getFromPidDomain(), metaData.getFromLNM(), metaData.getFromFNM(), metaData.getFromMNM(), null, metaData.getFromSSN(), metaData.getFromDOB(), metaData.getFromICN());
            patientOperations.auditIdModification(fromPatient, toPatient, this.originatingDomain, "LINK_AUDIT");
            retVal = true;
            if (!fromPatient.doICNMatch(toPatient)) {
                retVal = dataDomain.doAdtLink(fromPatient, toPatient, this.originatingDomain);
            } else if (fromPatient.doPatientMatch(toPatient)) {
                String unCorrelatedICN = patientOperations.checkDupPatientId(new PatientIdentifier(fromPatient.getPrefix() + fromPatient.getStationId(), fromPatient.getDomain()), fromPatient.getICN());
                if (unCorrelatedICN == null) {
                    ((CorrelatingDataDomain)dataDomain).storePatient(fromPatient);
                    PatientIdentifier fromPatientId = patientOperations.getPossibleCorrId(ICN_DATA_DOMAIN, fromPatient.getICN(), this.originatingDomain);
                    if (fromPatientId != null) {
                        patientOperations.auditToIdModification(fromPatient, fromPatientId.getId(), this.originatingDomain, "LINK");
                        retVal = true;
                    } else {
                        retVal = dataDomain.updateADT(fromPatient, fromPatient.getICN(), this.originatingDomain);
                    }
                } else {
                    fromPatient.setICN(unCorrelatedICN);
                    retVal = dataDomain.doAdtLink(fromPatient, toPatient, this.originatingDomain);
                }
            } else {
                retVal = dataDomain.updateADT(fromPatient, toPatient.getICN(), this.originatingDomain);
            }
        }
        catch (Exception e2) {
            throw new AdtProcessException("An error occurred when verifying the patient information for link Operation.", e2);
        }
        return retVal;
    }

    public boolean doUnlinkOperation(XMLDocumentA43MessageMetaData metaData) throws AdtProcessException {
        DataDomain dataDomain;
        boolean retVal = false;
        String unlinkICN = metaData.getMrgICN();
        try {
            if (!this.validAdtA43Message(metaData)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            if (unlinkICN == null) {
                throw new AdtProcessException("from ICN is missing:  " + unlinkICN);
            }
            throw new AdtProcessException("An error occurred trying to validate the structure of the ADT 43", e);
        }
        try {
            dataDomain = DataDomainLocator.getInstance().locate(this.originatingDomain);
        }
        catch (DataDomainLocatorException e1) {
            throw new AdtProcessException("An error occurred while trying to locate the DataDomain object for the domain: " + this.originatingDomain + ".", e1);
        }
        try {
            PatientOperationsDomain patientOperations = new PatientOperationsDomain(this.originatingDomain);
            PatientRecord toPatient = new PatientRecord(1, metaData.getToLocalId(), metaData.getToPidDomain(), metaData.getToLNM(), metaData.getToFNM(), metaData.getToMNM(), null, metaData.getToSSN(), metaData.getToDOB(), metaData.getToICN());
            PatientRecord mrgPatient = new PatientRecord(2, metaData.getMrgLocalId(), metaData.getMrgPidDomain(), metaData.getMrgLNM(), metaData.getMrgFNM(), metaData.getMrgMNM(), null, metaData.getMrgSSN(), null, metaData.getMrgICN());
            patientOperations.auditIdModification(mrgPatient, toPatient, this.originatingDomain, "UNLINK_AUDIT");
            retVal = dataDomain.doAdtUnlink(toPatient, mrgPatient, this.originatingDomain);
        }
        catch (Exception e2) {
            throw new AdtProcessException("An error occurred when verifying the patient information for unlink Operation.", e2);
        }
        return retVal;
    }

    private boolean validAdtA24Message(XMLDocumentA24MessageMetaData metaData) throws Exception {
        if (metaData.getFromICN() == null || metaData.getToICN() == null) {
            return false;
        }
        if (metaData.getFromLocalId() != null && metaData.getFromPidDomain().length() == 0) {
            throw new Exception("Bad ADT A24 HL7 Message, Local PID in message but no Station ID in PID 2");
        }
        if (metaData.getToLocalId() != null && metaData.getToPidDomain().length() == 0) {
            throw new Exception("Bad ADT A24 HL7 Message, Local PID in message but no Station ID in PID 1");
        }
        return true;
    }

    private boolean validAdtA43Message(XMLDocumentA43MessageMetaData metaData) throws Exception {
        if (metaData.getMrgICN() == null) {
            return false;
        }
        if (metaData.getMrgLocalId() != null && metaData.getMrgPidDomain().length() == 0) {
            throw new Exception("Bad ADT A43 HL7 Message, Local PID in message but no Station ID in MRG");
        }
        if (metaData.getToLocalId() != null && metaData.getToPidDomain().length() == 0) {
            throw new Exception("Bad ADT A43 HL7 Message, Local PID in message but no Station ID in PID 1");
        }
        return true;
    }

    public String getOriginatingDomain() {
        return this.originatingDomain;
    }

    public void setOriginatingDomain(String originatingDomain) {
        this.originatingDomain = originatingDomain;
    }
}

