/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service;

import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.service.ServiceRegistry;
import gov.va.med.hds.hdr.service.ServiceUnavailableException;
import gov.va.med.hds.hdr.service.dao.DAOFactory;
import gov.va.med.hds.hdr.service.dao.MappedDAOFactoryFactory;
import gov.va.med.hds.hdr.service.hl7.HL7Service;
import gov.va.med.hds.hdr.service.mpi.MasterPatientIndex;
import gov.va.med.hds.hdr.service.queryaccess.ClinicalQueryAccess;
import gov.va.med.hds.hdr.service.rules.RulesEngine;
import gov.va.med.hds.hdr.service.session.ImsSession;
import gov.va.med.hds.hdr.service.session.ImsSessionFactory;
import gov.va.med.hds.hdr.transformer.service.PropertyMgrServiceRegistry;
import java.lang.reflect.Method;
import org.springframework.jms.core.JmsTemplate;

public class ServiceLocator {
    private static final String XP_REGCLASS = "transformer/serviceLocator/@registryClass";
    private static ServiceLocator instance = new ServiceLocator();
    ServiceRegistry registry = null;

    private ServiceLocator() {
        PropertyMgr pm = PropertyMgr.getInstance();
        String clazz = pm.getProperty(XP_REGCLASS).getValue();
        if (clazz == null || clazz.length() == 0) {
            this.registry = PropertyMgrServiceRegistry.getInstance();
        }
        try {
            Method getInstanceMethod = Class.forName(clazz).getMethod("getInstance", null);
            this.registry = (ServiceRegistry)getInstanceMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            this.registry = PropertyMgrServiceRegistry.getInstance();
        }
    }

    public static ServiceLocator getInstance() {
        return instance;
    }

    public MasterPatientIndex getMPIService() throws ServiceUnavailableException {
        return (MasterPatientIndex)this.registry.find("masterPatientIndexService");
    }

    public JmsTemplate getJmsTemplate(String jmsTemplateId) throws ServiceUnavailableException {
        return (JmsTemplate)this.registry.find(jmsTemplateId);
    }

    public ClinicalQueryAccess getClinicalQueryAccessService(String originatingDomain) throws ServiceUnavailableException {
        ClinicalQueryAccess cqa = (ClinicalQueryAccess)this.registry.find("queryAccessService");
        cqa.setOriginatingDomain(originatingDomain);
        return cqa;
    }

    public DAOFactory getDAOFactory() throws ServiceUnavailableException {
        DAOFactory factory = null;
        Object obj = this.registry.find("dataAccess");
        if (obj instanceof MappedDAOFactoryFactory) {
            factory = ((MappedDAOFactoryFactory)obj).getFactory("");
        } else if (obj instanceof DAOFactory) {
            factory = (DAOFactory)obj;
        } else {
            throw new ServiceUnavailableException("There is no DOA factory service configured.");
        }
        return factory;
    }

    public DAOFactory getDAOFactory(String key) throws ServiceUnavailableException {
        Object obj = this.registry.find("dataAccess");
        if (obj instanceof MappedDAOFactoryFactory) {
            DAOFactory factory = ((MappedDAOFactoryFactory)obj).getFactory(key);
            return factory;
        }
        throw new ServiceUnavailableException("The method getDAOFactory(String template) requires the configuration of a MappedDAOFactoryFactory DAOFactory object.");
    }

    public RulesEngine getRulesEngine() throws ServiceUnavailableException {
        return (RulesEngine)this.registry.find("rulesEngine");
    }

    public HL7Service getHL7Service() throws ServiceUnavailableException {
        return (HL7Service)this.registry.find("hl7Service");
    }

    public ImsSession getImsSession() throws ServiceUnavailableException {
        return ((ImsSessionFactory)this.registry.find("imsSession")).getImsSession();
    }
}

