/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.nio.server;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.fhie.transformer.systemcontrol.ApplicationCtrlEvent;
import gov.fhie.transformer.systemcontrol.ApplicationCtrlListener;
import gov.va.med.hds.hdr.nio.server.Server;
import gov.va.med.hds.hdr.nio.server.ServerInitializationException;
import java.util.ArrayList;
import java.util.List;

public class ServerManager
implements ApplicationCtrlListener {
    private static ServerManager instance = null;
    private List<Server> servers = new ArrayList<Server>();

    private ServerManager() {
    }

    public static final ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public void startFileLoading(ApplicationCtrlEvent e) {
        PropertyElement[] serverElements = PropertyMgr.getInstance().getProperties("transformer/server");
        for (int i = 0; i < serverElements.length; ++i) {
            String name = serverElements[i].getAttribute("name");
            PropertyElement[] serverProps = serverElements[i].getChildProperties();
            try {
                Server server = new Server(name, serverProps);
                this.servers.add(server);
                continue;
            }
            catch (ServerInitializationException e1) {
                IMSException.getIMSException(e1, (CharSequence)("An error occurred while initializing server ['" + name + "']."), "ServerManager.startFileLoading");
            }
        }
    }

    public void stopFileLoading(ApplicationCtrlEvent e) {
        this.shutdown(null);
    }

    public void shutdown(ApplicationCtrlEvent e) {
        Server server2 = null;
        for (Server server2 : this.servers) {
            server2.shutdown();
        }
    }
}

