/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.nio.server;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.nio.ProtocolDecoder;
import gov.va.med.hds.hdr.nio.ProtocolEncoder;
import gov.va.med.hds.hdr.nio.SelectorThread;
import gov.va.med.hds.hdr.nio.listener.AcceptorListener;
import gov.va.med.hds.hdr.nio.listener.PacketChannelListener;
import gov.va.med.hds.hdr.nio.server.Acceptor;
import gov.va.med.hds.hdr.nio.server.PacketChannel;
import gov.va.med.hds.hdr.nio.server.PoolableRequestHandlerObjectFactory;
import gov.va.med.hds.hdr.nio.server.RequestHandler;
import gov.va.med.hds.hdr.nio.server.RequestHandlerPool;
import gov.va.med.hds.hdr.nio.server.ServerInitializationException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class Server
implements AcceptorListener,
PacketChannelListener {
    private final SelectorThread st;
    private int port = 5001;
    private int timeoutMilliseconds = 3000;
    private ObjectPool handlers = null;
    private int lingerSeconds = 2;
    private int queueDepth = 1024;
    private GenericObjectPool.Config poolConfig;
    private Class requestHander = null;
    private Class requestBroker = null;
    private Class decoder = null;
    private Class encoder = null;

    public Server(String name, PropertyElement[] props) throws ServerInitializationException {
        try {
            this.st = new SelectorThread(name);
        }
        catch (IOException e) {
            IMSException imse = IMSException.getIMSException(e, (CharSequence)"Server initialization failed. An error occurred while initializing the SelectorThread.", "Server.[Initialization]", ErrorCode.SRVR_001, new String[]{name});
            throw new ServerInitializationException(imse.getMessage(), imse);
        }
        this.loadProperties(props);
        this.handlers = new RequestHandlerPool((PoolableObjectFactory)new PoolableRequestHandlerObjectFactory(this, this.requestHander, this.requestBroker), this.poolConfig);
        Acceptor acceptor = new Acceptor(this.port, this.st, this, this.queueDepth);
        try {
            acceptor.openServerSocket();
        }
        catch (IOException e) {
            IMSException imse = IMSException.getIMSException(e, (CharSequence)"Server initialization failed. An error occured while opening server socket.", "Server.[Initialization]", ErrorCode.SRVR_001, new String[]{name});
            throw new ServerInitializationException(imse.getMessage(), imse);
        }
    }

    public ObjectPool getHandlers() {
        return this.handlers;
    }

    public void socketConnected(Acceptor acceptor, SocketChannel sc) {
        try {
            sc.socket().setReceiveBufferSize(1024);
            sc.socket().setSendBufferSize(1024);
            sc.socket().setSoTimeout(this.timeoutMilliseconds);
            sc.socket().setSoLinger(true, this.lingerSeconds);
            ProtocolDecoder pd = (ProtocolDecoder)this.decoder.newInstance();
            ProtocolEncoder pe = (ProtocolEncoder)this.encoder.newInstance();
            PacketChannel pc = new PacketChannel(sc, this.st, pd, pe, this);
            pc.resumeReading();
        }
        catch (Exception e) {
            IMSException.getIMSException(e, (CharSequence)"An error occurred while intializing the socket connection.", "Server.socketConnected");
        }
    }

    public void socketError(Acceptor acceptor, Exception ex) {
        IMSException.getIMSException(ex, (CharSequence)"A socket error occurred.", "Server.socketError");
    }

    public void packetArrived(PacketChannel pc, ByteBuffer pckt) {
        try {
            RequestHandler requestHandler = (RequestHandler)this.handlers.borrowObject();
            requestHandler.notifyHandler(pc, pckt);
        }
        catch (Exception e) {
            IMSException.getIMSException(e, (CharSequence)"An error occurred while processing request.", "Server.packetArrived");
        }
    }

    public void socketException(PacketChannel pc, Exception ex) {
        IMSException.getIMSException(ex, (CharSequence)"A socket exception occurred.", "Server.socketException");
    }

    public void socketDisconnected(PacketChannel pc) {
    }

    public void packetSent(PacketChannel pc, ByteBuffer pckt) {
        try {
            pc.resumeReading();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.st.requestClose();
    }

    private void loadProperties(PropertyElement[] serverProps) throws ServerInitializationException {
        String rhc;
        String sqd;
        String tom;
        String softMinEvictableIdleTimeMillis;
        String minEvictableIdleTimeMillis;
        String numTestsPerEvictionRun;
        String timeBetweenEvictionRunsMillis;
        String testWhileIdle;
        String testOnReturn;
        String testOnBorrow;
        String whenExhaustedAction;
        String maxWait;
        String maxActive;
        String minIdle;
        String p = this.getProperty(serverProps, "listening-port");
        if (p != null && p.length() > 0) {
            try {
                this.port = Integer.parseInt(p);
            }
            catch (NumberFormatException e) {
                throw new ServerInitializationException("The port value of the server configuration must be a positive integer.", e);
            }
        }
        this.poolConfig = new GenericObjectPool.Config();
        String maxIdle = this.getProperty(serverProps, "poolConfig-maxIdle");
        if (maxIdle != null && maxIdle.length() > 0) {
            try {
                this.poolConfig.maxIdle = Integer.parseInt(maxIdle);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The maxIdle property of the pool must be a positive integer.", nfe);
            }
        }
        if ((minIdle = this.getProperty(serverProps, "poolConfig-minIdle")) != null && minIdle.length() > 0) {
            try {
                this.poolConfig.minIdle = Integer.parseInt(minIdle);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The minIdle property of the pool must be a positive integer.", nfe);
            }
        }
        if ((maxActive = this.getProperty(serverProps, "poolConfig-maxActive")) != null && maxActive.length() > 0) {
            try {
                this.poolConfig.maxActive = Integer.parseInt(maxActive);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The maxActive property of the pool must be a positive integer.", nfe);
            }
        }
        if ((maxWait = this.getProperty(serverProps, "poolConfig-maxWait")) != null && maxWait.length() > 0) {
            try {
                this.poolConfig.maxWait = Integer.parseInt(maxWait);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The maxWait property of the pool must be a positive integer.", nfe);
            }
        }
        if ((whenExhaustedAction = this.getProperty(serverProps, "poolConfig-whenExhaustedAction")) != null && whenExhaustedAction.length() > 0) {
            try {
                this.poolConfig.whenExhaustedAction = Byte.parseByte(whenExhaustedAction);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The whenExhaustedAction property of the pool must be a non-negative integer between 0 and 2.", nfe);
            }
        }
        if ((testOnBorrow = this.getProperty(serverProps, "poolConfig-testOnBorrow")) != null && testOnBorrow.length() > 0) {
            this.poolConfig.testOnBorrow = Boolean.parseBoolean(testOnBorrow);
        }
        if ((testOnReturn = this.getProperty(serverProps, "poolConfig-testOnReturn")) != null && testOnReturn.length() > 0) {
            this.poolConfig.testOnReturn = Boolean.parseBoolean(testOnReturn);
        }
        if ((testWhileIdle = this.getProperty(serverProps, "poolConfig-testWhileIdle")) != null && testWhileIdle.length() > 0) {
            this.poolConfig.testWhileIdle = Boolean.parseBoolean(testWhileIdle);
        }
        if ((timeBetweenEvictionRunsMillis = this.getProperty(serverProps, "poolConfig-timeBetweenEvictionRunsMillis")) != null && timeBetweenEvictionRunsMillis.length() > 0) {
            try {
                this.poolConfig.timeBetweenEvictionRunsMillis = Integer.parseInt(timeBetweenEvictionRunsMillis);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The timeBetweenEvictionRunsMillis property of the pool must be a positive integer.", nfe);
            }
        }
        if ((numTestsPerEvictionRun = this.getProperty(serverProps, "poolConfig-numTestsPerEvictionRun")) != null && numTestsPerEvictionRun.length() > 0) {
            try {
                this.poolConfig.numTestsPerEvictionRun = Integer.parseInt(numTestsPerEvictionRun);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The numTestsPerEvictionRun property of the pool must be a positive integer.", nfe);
            }
        }
        if ((minEvictableIdleTimeMillis = this.getProperty(serverProps, "poolConfig-minEvictableIdleTimeMillis")) != null && minEvictableIdleTimeMillis.length() > 0) {
            try {
                this.poolConfig.minEvictableIdleTimeMillis = Integer.parseInt(minEvictableIdleTimeMillis);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The minEvictableIdleTimeMillis property of the pool must be a positive integer.", nfe);
            }
        }
        if ((softMinEvictableIdleTimeMillis = this.getProperty(serverProps, "poolConfig-softMinEvictableIdleTimeMillis")) != null && softMinEvictableIdleTimeMillis.length() > 0) {
            try {
                this.poolConfig.softMinEvictableIdleTimeMillis = Integer.parseInt(softMinEvictableIdleTimeMillis);
            }
            catch (NumberFormatException nfe) {
                throw new ServerInitializationException("The softMinEvictableIdleTimeMillis property of the pool must be a positive integer.", nfe);
            }
        }
        if ((tom = this.getProperty(serverProps, "timeout-milliseconds")) != null && tom.length() > 0) {
            try {
                this.timeoutMilliseconds = Integer.parseInt(tom);
            }
            catch (NumberFormatException e) {
                throw new ServerInitializationException("The timeout milliseconds configuration paramter must be a positive integer.", e);
            }
        } else {
            throw new ServerInitializationException("Timeout milliseconds parameter not specified in application configuration.");
        }
        String lts = this.getProperty(serverProps, "linger-time-seconds");
        if (lts != null && lts.length() > 0) {
            try {
                this.lingerSeconds = Integer.parseInt(lts);
            }
            catch (NumberFormatException e) {
                throw new ServerInitializationException("The linger time seconds configuration paramter must be a positive integer.", e);
            }
        }
        if ((sqd = this.getProperty(serverProps, "socket-queue-depth")) != null && sqd.length() > 0) {
            try {
                this.queueDepth = Integer.parseInt(sqd);
            }
            catch (NumberFormatException e) {
                throw new ServerInitializationException("The socket queue depth configuration paramter must be a positive integer.", e);
            }
        }
        if ((rhc = this.getProperty(serverProps, "request-handler-class")) != null && rhc.length() > 0) {
            try {
                this.requestHander = Class.forName(rhc);
            }
            catch (ClassNotFoundException e) {
                throw new ServerInitializationException("An error occurred while loading handler class for RPC server.", e);
            }
        } else {
            throw new ServerInitializationException("Request handler configuration parameter not specified in application configuration.");
        }
        String rbc = this.getProperty(serverProps, "request-broker-class");
        if (rbc != null && rbc.length() > 0) {
            try {
                this.requestBroker = Class.forName(rbc);
            }
            catch (ClassNotFoundException e) {
                throw new ServerInitializationException("An error occurred while loading broker class for server.", e);
            }
        } else {
            throw new ServerInitializationException("Request broker configuration parameter not specified in application configuration.");
        }
        String pd = this.getProperty(serverProps, "protocol-decoder");
        if (pd != null && pd.length() > 0) {
            try {
                this.decoder = Class.forName(pd);
            }
            catch (Exception e) {
                throw new ServerInitializationException("An error occurred while creating the protocol decoder.", e);
            }
        } else {
            throw new ServerInitializationException("Protocol decoder configuration parameter not specified in application configuration.");
        }
        String pe = this.getProperty(serverProps, "protocol-encoder");
        if (pe != null && pe.length() > 0) {
            try {
                this.encoder = Class.forName(pe);
            }
            catch (Exception e) {
                throw new ServerInitializationException("An error occurred while creating the protocol encoder.", e);
            }
        } else {
            throw new ServerInitializationException("Protocol encoder configuration parameter not specified in application configuration.");
        }
    }

    private String getProperty(PropertyElement[] props, String key) {
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getAttribute("key").equalsIgnoreCase(key)) continue;
            return props[i].getAttribute("value");
        }
        return null;
    }
}

