/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.nio.server;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.rpc.broker.RequestBroker;
import gov.va.med.hds.hdr.manage.mbean.AbstractDynamicMBean;
import gov.va.med.hds.hdr.nio.CallbackErrorHandler;
import gov.va.med.hds.hdr.nio.server.PacketChannel;
import gov.va.med.hds.hdr.nio.server.RequestHandlerDynamicMBean;
import gov.va.med.hds.hdr.nio.server.Server;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.session.ImsSession;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHandler
extends Thread {
    private AbstractDynamicMBean dMBean;
    private long requestsHandled;
    private String lastRequest;
    private long lastElapsed;
    private LinkedList<Long> lastElapsedList = new LinkedList();
    private float rollingAverage;
    private long lastTime;
    private ByteBuffer buffer = null;
    private final Server server;
    protected Class brokerClass = null;
    protected Thread thisThread;
    protected PacketChannel packetChannel = null;

    public RequestHandler(Server server, Class brokerClass) {
        this.server = server;
        this.brokerClass = brokerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void run() {
        ImsSession session = null;
        this.setName(this.getClass().getSimpleName() + "[" + this.getId() + "]");
        try {
            this.dMBean = new RequestHandlerDynamicMBean(this);
            this.dMBean.register();
        }
        catch (Exception e) {
            IMSException.getIMSException(e);
        }
        while (true) {
            long endTime;
            if (this.buffer == null || this.packetChannel == null) {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException except) {
                    break;
                }
            }
            this.lastTime = System.currentTimeMillis();
            this.thisThread = Thread.currentThread();
            session = ServiceLocator.getInstance().getImsSession();
            this.handleRequest();
            Object var4_6 = null;
            try {
                session.doPreDestroy();
                session.doDestroy();
                this.lastRequest = new String(this.buffer.array());
                this.buffer = null;
                this.packetChannel = null;
                endTime = System.currentTimeMillis();
                this.rollingAverage = this.addLastElapsed(endTime - this.lastTime);
                ++this.requestsHandled;
            }
            catch (Exception e322) {
                IMSException.getIMSException("Error finalizing request.", e322);
            }
            finally {
                try {
                    this.server.getHandlers().returnObject((Object)this);
                }
                catch (Exception e322) {
                    IMSException.getIMSException(e322, (CharSequence)"Error returning request handler to pool.");
                }
            }
            {
                continue;
                catch (Exception e) {
                    session.doException();
                    IMSException.getIMSException("An exception was thrown while handling request.", e);
                    var4_6 = null;
                    session.doPreDestroy();
                    session.doDestroy();
                    this.lastRequest = new String(this.buffer.array());
                    this.buffer = null;
                    this.packetChannel = null;
                    endTime = System.currentTimeMillis();
                    this.rollingAverage = this.addLastElapsed(endTime - this.lastTime);
                    ++this.requestsHandled;
                    try {
                        this.server.getHandlers().returnObject((Object)this);
                    }
                    catch (Exception e2) {
                        IMSException.getIMSException(e2, (CharSequence)"Error returning request handler to pool.");
                    }
                    continue;
                    catch (Exception e322) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                this.server.getHandlers().returnObject((Object)this);
                            }
                            catch (Exception e4) {
                                IMSException.getIMSException(e4, (CharSequence)"Error returning request handler to pool.");
                            }
                            throw throwable;
                        }
                        IMSException.getIMSException("Error finalizing request.", e322);
                        try {
                            this.server.getHandlers().returnObject((Object)this);
                        }
                        catch (Exception e322) {
                            IMSException.getIMSException(e322, (CharSequence)"Error returning request handler to pool.");
                        }
                        continue;
                    }
                }
            }
            catch (Throwable throwable) {
                block33: {
                    var4_6 = null;
                    session.doPreDestroy();
                    session.doDestroy();
                    this.lastRequest = new String(this.buffer.array());
                    this.buffer = null;
                    this.packetChannel = null;
                    endTime = System.currentTimeMillis();
                    this.rollingAverage = this.addLastElapsed(endTime - this.lastTime);
                    ++this.requestsHandled;
                    try {
                        this.server.getHandlers().returnObject((Object)this);
                    }
                    catch (Exception e2) {
                        IMSException.getIMSException(e2, (CharSequence)"Error returning request handler to pool.");
                    }
                    break block33;
                    catch (Exception e322) {
                        try {}
                        catch (Throwable throwable2) {
                            try {
                                this.server.getHandlers().returnObject((Object)this);
                            }
                            catch (Exception e4) {
                                IMSException.getIMSException(e4, (CharSequence)"Error returning request handler to pool.");
                            }
                            throw throwable2;
                        }
                        IMSException.getIMSException("Error finalizing request.", e322);
                        try {
                            this.server.getHandlers().returnObject((Object)this);
                        }
                        catch (Exception e322) {
                            IMSException.getIMSException(e322, (CharSequence)"Error returning request handler to pool.");
                        }
                    }
                }
                throw throwable;
            }
            break;
        }
        if (null != this.dMBean) {
            this.dMBean.unregister();
        }
    }

    private void handleRequest() throws Exception {
        if (this.buffer != null) {
            RequestBroker broker = (RequestBroker)this.brokerClass.newInstance();
            ByteBuffer response = broker.invoke(this.buffer);
            this.packetChannel.sendPacketLater(response, new CallbackErrorHandler(){

                public void handleError(Exception ex) {
                    IMSException.getIMSException(ex, (CharSequence)"An error occurred sending the response message to client.", "RequestHandler.handleRequest.[inner]CallbackHandler.handleError");
                }
            });
        }
    }

    public synchronized void notifyHandler(PacketChannel pc, ByteBuffer buffer) {
        this.packetChannel = pc;
        this.buffer = buffer;
        this.notify();
    }

    public final long getLastElapsed() {
        return this.lastElapsed;
    }

    public final String getLastRequest() {
        return this.lastRequest;
    }

    public final long getRequestsHandled() {
        return this.requestsHandled;
    }

    public final float getRollingAverage() {
        return this.rollingAverage;
    }

    public final long getLastTimeStamp() {
        return this.lastTime;
    }

    public final Date getLastTime() {
        return new Date(this.lastTime);
    }

    public final void resetStats() {
        this.lastElapsed = 0L;
        this.requestsHandled = 0L;
        this.rollingAverage = 0L;
        this.lastRequest = null;
        this.lastTime = System.currentTimeMillis();
        this.lastElapsedList.clear();
    }

    public final Long[] getLastHundred() {
        return this.lastElapsedList.toArray(new Long[this.lastElapsedList.size()]);
    }

    private final float addLastElapsed(long currentElapsed) {
        this.lastElapsed = currentElapsed;
        this.lastElapsedList.addFirst(this.lastElapsed);
        if (100 < this.lastElapsedList.size()) {
            this.lastElapsedList.removeLast();
        }
        float totalElapsed = 0.0f;
        Iterator i$ = this.lastElapsedList.iterator();
        while (i$.hasNext()) {
            long elapsed = (Long)i$.next();
            totalElapsed += (float)elapsed;
        }
        return totalElapsed / (float)this.lastElapsedList.size();
    }

    private String generateSessionId(Hashtable<String, Object> auditInfo) {
        StringBuffer sessionId = new StringBuffer();
        String purpose = (String)auditInfo.get("purpose");
        String sendingFacility = (String)auditInfo.get("sendingFacility");
        String msgCtrlId = (String)auditInfo.get("originalMessageControlId");
        long startTime = (Long)auditInfo.get("startTime");
        long completeTime = (Long)auditInfo.get("completionTime");
        sessionId.append(null == purpose ? "" : purpose);
        if (null != sendingFacility || null != msgCtrlId) {
            sessionId.append("[").append(null == sendingFacility ? "" : sendingFacility).append(null == msgCtrlId ? "" : msgCtrlId).append("]");
        }
        sessionId.append(startTime + completeTime);
        return sessionId.toString();
    }
}

