/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.nio.server;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.nio.CallbackErrorHandler;
import gov.va.med.hds.hdr.nio.ProtocolDecoder;
import gov.va.med.hds.hdr.nio.ProtocolEncoder;
import gov.va.med.hds.hdr.nio.ReadWriteSelectorHandler;
import gov.va.med.hds.hdr.nio.SelectorThread;
import gov.va.med.hds.hdr.nio.listener.PacketChannelListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public final class PacketChannel
implements ReadWriteSelectorHandler {
    protected final SelectorThread selector;
    private final SocketChannel sc;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer = null;
    private final ProtocolDecoder protocolDecoder;
    private final ProtocolEncoder protocolEncoder;
    private final PacketChannelListener listener;

    public PacketChannel(SocketChannel socketChannel, SelectorThread selector, ProtocolDecoder protocolDecoder, ProtocolEncoder protocolEncoder, PacketChannelListener listener) throws IOException {
        this.selector = selector;
        this.protocolDecoder = protocolDecoder;
        this.protocolEncoder = protocolEncoder;
        this.sc = socketChannel;
        this.listener = listener;
        this.inBuffer = ByteBuffer.allocateDirect(this.sc.socket().getReceiveBufferSize());
        this.inBuffer.position(this.inBuffer.capacity());
        selector.registerChannelNow(this.sc, 0, this);
    }

    public void resumeReading() throws IOException {
        this.processInBuffer();
    }

    public void close() {
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleRead() {
        try {
            int readBytes = this.sc.read(this.inBuffer);
            if (readBytes == -1) {
                this.close();
                this.listener.socketDisconnected(this);
                return;
            }
            if (readBytes == 0) {
                this.reactivateReading();
                return;
            }
            this.inBuffer.flip();
            this.processInBuffer();
        }
        catch (IOException ex) {
            this.close();
            this.listener.socketException(this, ex);
        }
    }

    private void processInBuffer() throws IOException {
        ByteBuffer packet = this.protocolDecoder.decode(this.inBuffer);
        if (packet == null) {
            this.inBuffer.clear();
            this.reactivateReading();
        } else {
            this.listener.packetArrived(this, packet);
        }
    }

    public void disableReading() throws IOException {
        this.selector.removeChannelInterestNow(this.sc, 1);
    }

    private void reactivateReading() throws IOException {
        this.selector.addChannelInterestNow(this.sc, 1);
    }

    public void sendPacket(ByteBuffer packet) {
        try {
            this.outBuffer = this.protocolEncoder.encode(packet);
        }
        catch (IOException ioe) {
            IMSException.getIMSException(ioe, (CharSequence)"An error occured while encoded packet.", "PacketChannel.sendPacket(ByteBuffer)");
        }
        this.handleWrite();
    }

    public void sendPacketLater(ByteBuffer packet, CallbackErrorHandler errorHandler) {
        try {
            this.outBuffer = this.protocolEncoder.encode(packet);
        }
        catch (IOException ioe) {
            IMSException.getIMSException(ioe, (CharSequence)"An error occured while encoded packet.", "PacketChannel.sendPacketLater(ByteBuffer, CallbackErrorHandler)");
        }
        this.selector.addChannelInterestLater(this.sc, 4, errorHandler);
    }

    private void requestWrite() throws IOException {
        this.selector.addChannelInterestNow(this.sc, 4);
    }

    public void handleWrite() {
        int written = 0;
        try {
            if (this.sc.isOpen()) {
                written = this.sc.write(this.outBuffer);
            }
            if (this.outBuffer.hasRemaining()) {
                this.requestWrite();
            } else {
                ByteBuffer sentPacket = this.outBuffer;
                this.outBuffer = null;
                this.listener.packetSent(this, sentPacket);
            }
        }
        catch (IOException ioe) {
            this.close();
            this.listener.socketException(this, ioe);
        }
    }

    public SocketChannel getSocketChannel() {
        return this.sc;
    }

    public String toString() {
        return Integer.toString(this.sc.socket().getLocalPort()) + ":" + Integer.toString(this.sc.socket().getPort());
    }
}

