/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.nio.server;

import gov.va.med.hds.hdr.nio.CallbackErrorHandler;
import gov.va.med.hds.hdr.nio.ConnectorSelectorHandler;
import gov.va.med.hds.hdr.nio.SelectorThread;
import gov.va.med.hds.hdr.nio.listener.ConnectorListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public final class Connector
implements ConnectorSelectorHandler {
    private SocketChannel sc;
    private final InetSocketAddress remoteAddress;
    private final SelectorThread selectorThread;
    private final ConnectorListener listener;

    public Connector(SelectorThread selector, InetSocketAddress remoteAddress, ConnectorListener listener) {
        this.selectorThread = selector;
        this.remoteAddress = remoteAddress;
        this.listener = listener;
    }

    public void connect() throws IOException {
        this.sc = SocketChannel.open();
        this.sc.configureBlocking(false);
        this.sc.connect(this.remoteAddress);
        this.selectorThread.registerChannelLater(this.sc, 8, this, new CallbackErrorHandler(){

            public void handleError(Exception ex) {
                Connector.this.listener.connectionFailed(Connector.this, ex);
            }
        });
    }

    public void handleConnect() {
        try {
            if (!this.sc.finishConnect()) {
                this.listener.connectionFailed(this, null);
                return;
            }
            this.listener.connectionEstablished(this, this.sc);
        }
        catch (IOException ex) {
            this.listener.connectionFailed(this, ex);
        }
    }

    public String toString() {
        return "Remote endpoint: " + this.remoteAddress.getAddress().getHostAddress() + ":" + this.remoteAddress.getPort();
    }
}

