/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.nio.server;

import gov.va.med.hds.hdr.nio.AcceptSelectorHandler;
import gov.va.med.hds.hdr.nio.CallbackErrorHandler;
import gov.va.med.hds.hdr.nio.SelectorThread;
import gov.va.med.hds.hdr.nio.listener.AcceptorListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class Acceptor
implements AcceptSelectorHandler {
    private ServerSocketChannel ssc;
    private final SelectorThread ioThread;
    private final int listenPort;
    private final int queueDepth;
    private final AcceptorListener listener;

    public Acceptor(int listenPort, SelectorThread ioThread, AcceptorListener listener) {
        this.ioThread = ioThread;
        this.listenPort = listenPort;
        this.listener = listener;
        this.queueDepth = 1024;
    }

    public Acceptor(int listenPort, SelectorThread ioThread, AcceptorListener listener, int queueDepth) {
        this.ioThread = ioThread;
        this.listenPort = listenPort;
        this.listener = listener;
        this.queueDepth = queueDepth < 1 ? 1024 : queueDepth;
    }

    public void openServerSocket() throws IOException {
        this.ssc = ServerSocketChannel.open();
        InetSocketAddress isa = new InetSocketAddress(this.listenPort);
        this.ssc.socket().bind(isa, this.queueDepth);
        this.ioThread.registerChannelLater(this.ssc, 16, this, new CallbackErrorHandler(){

            public void handleError(Exception ex) {
                Acceptor.this.listener.socketError(Acceptor.this, ex);
            }
        });
    }

    public String toString() {
        return "ListenPort: " + this.listenPort;
    }

    public void handleAccept() {
        SocketChannel sc = null;
        try {
            sc = this.ssc.accept();
            Socket s = sc.socket();
            this.ioThread.addChannelInterestNow(this.ssc, 16);
        }
        catch (IOException e) {
            this.listener.socketError(this, e);
        }
        if (sc != null) {
            this.listener.socketConnected(this, sc);
        }
    }

    public void close() {
        try {
            this.ioThread.invokeAndWait(new Runnable(){

                public void run() {
                    if (Acceptor.this.ssc != null) {
                        try {
                            Acceptor.this.ssc.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

