/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.nio;

import gov.va.med.hds.hdr.nio.AcceptSelectorHandler;
import gov.va.med.hds.hdr.nio.CallbackErrorHandler;
import gov.va.med.hds.hdr.nio.ConnectorSelectorHandler;
import gov.va.med.hds.hdr.nio.ReadWriteSelectorHandler;
import gov.va.med.hds.hdr.nio.SelectorHandler;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class SelectorThread
implements Runnable {
    private Selector selector;
    private final Thread selectorThread;
    private boolean closeRequested = false;
    private final List<Runnable> pendingInvocations = new ArrayList<Runnable>(32);

    public SelectorThread(String name) throws IOException {
        this.selector = Selector.open();
        this.selectorThread = new Thread(this);
        this.selectorThread.setName(name + "[" + this.selectorThread.getId() + "]");
        this.selectorThread.start();
    }

    public void requestClose() {
        this.closeRequested = true;
        this.selector.wakeup();
        try {
            this.selectorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addChannelInterestNow(SelectableChannel channel, int interest) throws IOException {
        if (Thread.currentThread() != this.selectorThread) {
            throw new IOException("Method can only be called from selector thread");
        }
        SelectionKey sk = channel.keyFor(this.selector);
        this.changeKeyInterest(sk, sk.interestOps() | interest);
    }

    public void addChannelInterestLater(final SelectableChannel channel, final int interest, final CallbackErrorHandler errorHandler) {
        this.invokeLater(new Runnable(){

            public void run() {
                try {
                    SelectorThread.this.addChannelInterestNow(channel, interest);
                }
                catch (IOException e) {
                    errorHandler.handleError(e);
                }
            }
        });
    }

    public void removeChannelInterestNow(SelectableChannel channel, int interest) throws IOException {
        if (Thread.currentThread() != this.selectorThread) {
            throw new IOException("Method can only be called from selector thread");
        }
        SelectionKey sk = channel.keyFor(this.selector);
        this.changeKeyInterest(sk, sk.interestOps() & ~interest);
    }

    public void removeChannelInterestLater(final SelectableChannel channel, final int interest, final CallbackErrorHandler errorHandler) {
        this.invokeLater(new Runnable(){

            public void run() {
                try {
                    SelectorThread.this.removeChannelInterestNow(channel, interest);
                }
                catch (IOException e) {
                    errorHandler.handleError(e);
                }
            }
        });
    }

    private void changeKeyInterest(SelectionKey sk, int newInterest) throws IOException {
        try {
            sk.interestOps(newInterest);
        }
        catch (CancelledKeyException cke) {
            IOException ioe = new IOException("Failed to change channel interest.");
            ioe.initCause(cke);
            throw ioe;
        }
    }

    public void registerChannelLater(final SelectableChannel channel, final int selectionKeys, final SelectorHandler handlerInfo, final CallbackErrorHandler errorHandler) {
        this.invokeLater(new Runnable(){

            public void run() {
                try {
                    SelectorThread.this.registerChannelNow(channel, selectionKeys, handlerInfo);
                }
                catch (IOException e) {
                    errorHandler.handleError(e);
                }
            }
        });
    }

    public void registerChannelNow(SelectableChannel channel, int selectionKeys, SelectorHandler handlerInfo) throws IOException {
        if (Thread.currentThread() != this.selectorThread) {
            throw new IOException("Method can only be called from selector thread");
        }
        if (!channel.isOpen()) {
            throw new IOException("Channel is not open.");
        }
        try {
            if (channel.isRegistered()) {
                SelectionKey sk = channel.keyFor(this.selector);
                assert (sk != null) : "Channel is already registered with other selector";
                sk.interestOps(selectionKeys);
                Object previousAttach = sk.attach(handlerInfo);
                assert (previousAttach != null);
            } else {
                channel.configureBlocking(false);
                channel.register(this.selector, selectionKeys, handlerInfo);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error registering channel.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable run) {
        List<Runnable> list = this.pendingInvocations;
        synchronized (list) {
            this.pendingInvocations.add(run);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(final Runnable task) throws InterruptedException {
        if (Thread.currentThread() == this.selectorThread) {
            task.run();
        } else {
            Object latch;
            Object object = latch = new Object();
            synchronized (object) {
                this.invokeLater(new Runnable(){

                    public void run() {
                        task.run();
                        latch.notify();
                    }
                });
                latch.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvocations() {
        List<Runnable> list = this.pendingInvocations;
        synchronized (list) {
            for (int i = 0; i < this.pendingInvocations.size(); ++i) {
                Runnable task = this.pendingInvocations.get(i);
                task.run();
            }
            this.pendingInvocations.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block6: while (true) {
            this.doInvocations();
            if (this.closeRequested) {
                return;
            }
            selectedKeys = 0;
            try {
                selectedKeys = this.selector.select();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            if (selectedKeys == 0) continue;
            it = this.selector.selectedKeys().iterator();
            while (true) {
                if (it.hasNext()) ** break;
                continue block6;
                sk = it.next();
                it.remove();
                try {
                    readyOps = sk.readyOps();
                    sk.interestOps(sk.interestOps() & ~readyOps);
                    handler = (SelectorHandler)sk.attachment();
                    if (sk.isAcceptable()) {
                        ((AcceptSelectorHandler)handler).handleAccept();
                        continue;
                    }
                    if (sk.isConnectable()) {
                        ((ConnectorSelectorHandler)handler).handleConnect();
                        continue;
                    }
                    rwHandler = (ReadWriteSelectorHandler)handler;
                    if (sk.isReadable()) {
                        rwHandler.handleRead();
                    }
                    if (!sk.isValid() || !sk.isWritable()) continue;
                    rwHandler.handleWrite();
                    continue;
                }
                catch (Throwable t) {
                    try {
                        sk.channel().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    t.printStackTrace();
                    continue;
                }
                break;
            }
            break;
        }
    }

    private void closeSelectorAndChannels() {
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            try {
                key.channel().close();
            }
            catch (IOException e) {}
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

