/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.mapping.da.instruction;

import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.mapping.bean.BeanMutator;
import gov.va.med.hds.hdr.mapping.da.ByteCodeRegistry;
import gov.va.med.hds.hdr.mapping.da.SegmentDataMapper;
import gov.va.med.hds.hdr.mapping.da.instruction.AbstractInstruction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PopulateInstruction
extends AbstractInstruction {
    private static final int C_IDX = 0;
    private static final int S_IDX = 1;
    protected String key;
    protected Map attributeMap;
    protected ByteCodeRegistry bytecodeRegistry;

    protected void doInstruction(Map data, String value) {
        Object obj = data.get(this.key);
        HL7MessageInfo messageInfo = (HL7MessageInfo)data.get("messageInfo");
        Set keys = this.attributeMap.keySet();
        Iterator iter = keys.iterator();
        BeanMutator cvMutator = null;
        String nextKey = null;
        String nextVal = null;
        String val = null;
        int[] indicies = null;
        while (iter.hasNext()) {
            nextKey = (String)iter.next();
            nextVal = (String)this.attributeMap.get(nextKey);
            indicies = this.parseIndicies(nextKey);
            val = SegmentDataMapper.getFieldData(value, indicies[0], indicies[1], messageInfo);
            cvMutator = this.bytecodeRegistry.getMutatorFactory(nextVal).createInstance();
            cvMutator.setMutatee(obj);
            cvMutator.setValue(val);
        }
    }

    private int[] parseIndicies(String index) {
        int[] indicies = new int[2];
        String[] strIdxs = index.split("\\.");
        Arrays.fill(indicies, 0);
        for (int i = 0; i < strIdxs.length; ++i) {
            indicies[i] = Integer.parseInt(strIdxs[i]);
        }
        return indicies;
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map attributeMap) {
        this.attributeMap = attributeMap;
    }

    public ByteCodeRegistry getBytecodeRegistry() {
        return this.bytecodeRegistry;
    }

    public void setBytecodeRegistry(ByteCodeRegistry bytecodeRegistry) {
        this.bytecodeRegistry = bytecodeRegistry;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

