/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.mapping.da.instruction;

import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.mapping.bean.BeanMutator;
import gov.va.med.hds.hdr.mapping.bean.BeanObjectFactory;
import gov.va.med.hds.hdr.mapping.da.ByteCodeRegistry;
import gov.va.med.hds.hdr.mapping.da.SegmentDataMapper;
import gov.va.med.hds.hdr.mapping.da.instruction.AbstractInstruction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAndPopulateInstruction
extends AbstractInstruction {
    private static final int C_IDX = 0;
    private static final int S_IDX = 1;
    private String key;
    private BeanObjectFactory factory;
    private Map attributeMap;
    private ByteCodeRegistry bytecodeRegistry;

    @Override
    protected void doInstruction(Map<String, Object> data, String value) {
        Object obj = this.factory.createInstance();
        HL7MessageInfo messageInfo = (HL7MessageInfo)data.get("messageInfo");
        Set keys = this.attributeMap.keySet();
        Iterator iter = keys.iterator();
        BeanMutator cvMutator = null;
        String nextKey = null;
        String nextVal = null;
        String val = null;
        int[] indicies = null;
        while (iter.hasNext()) {
            nextKey = (String)iter.next();
            nextVal = (String)this.attributeMap.get(nextKey);
            indicies = this.parseIndicies(nextKey);
            val = SegmentDataMapper.getFieldData(value, indicies[0], indicies[1], messageInfo);
            cvMutator = this.bytecodeRegistry.getMutatorFactory(nextVal).createInstance();
            cvMutator.setMutatee(obj);
            cvMutator.setValue(val);
        }
        data.put(this.key, this.postProcess(data, obj));
    }

    protected Object postProcess(Map<String, Object> data, Object obj) {
        return obj;
    }

    private int[] parseIndicies(String index) {
        int[] indicies = new int[]{0, 0};
        int dotIdx = index.indexOf(46);
        if (dotIdx != -1) {
            indicies[0] = Integer.parseInt(index.substring(0, dotIdx));
            indicies[1] = Integer.parseInt(index.substring(dotIdx + 1));
        } else {
            indicies[0] = Integer.parseInt(index);
        }
        return indicies;
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map attributeMap) {
        this.attributeMap = attributeMap;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ByteCodeRegistry getBytecodeRegistry() {
        return this.bytecodeRegistry;
    }

    public void setBytecodeRegistry(ByteCodeRegistry bytecodeRegistry) {
        this.bytecodeRegistry = bytecodeRegistry;
    }

    public BeanObjectFactory getFactory() {
        return this.factory;
    }

    public void setFactory(BeanObjectFactory factory) {
        this.factory = factory;
    }
}

