/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.mapping.da;

import gov.va.med.hds.hdr.common.util.RegularExpressionHelper;
import gov.va.med.hds.hdr.common.util.StringHelper;
import gov.va.med.hds.hdr.hl7.HL7EscapeCharacterDecoder;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.mapping.da.hl7.Field;
import gov.va.med.hds.hdr.mapping.da.hl7.SegmentSpecification;
import gov.va.med.hds.hdr.mapping.da.instruction.Instruction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentDataMapper {
    private static final int C_IDX = 0;
    private static final int S_IDX = 1;
    private String name;
    private String text;
    private String[] fields;
    private SegmentSpecification segmentSpecification;
    private HL7MessageInfo messageInfo;
    private Map<String, Object> data;

    public HL7MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public void setMessageInfo(HL7MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SegmentSpecification getSegmentSpecification() {
        return this.segmentSpecification;
    }

    public void setSegmentSpecification(SegmentSpecification segmentSpecification) {
        this.segmentSpecification = segmentSpecification;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.fields = this.getFields(this.text);
    }

    public void executeInstructions() {
        List mappedFields = this.segmentSpecification.getMappedFields();
        if (mappedFields != null) {
            for (Field field : mappedFields) {
                String regex = field.getRegex();
                String[] fields = this.fields.length >= field.getIndex() ? this.fields[field.getIndex() - 1].split(RegularExpressionHelper.escape(this.messageInfo.getRepetitionSeparator())) : new String[]{};
                for (int i = 0; i < fields.length; ++i) {
                    if (regex != null && !fields[i].matches(regex)) continue;
                    for (Instruction instruction : field.getInstructions()) {
                        int[] indices = this.getIndices(instruction.getIndex());
                        String s = SegmentDataMapper.getFieldData(fields[i], indices[0], indices[1], this.messageInfo);
                        instruction.execute(this.data, HL7EscapeCharacterDecoder.decodeString((String)s, (HL7MessageInfo)this.messageInfo));
                    }
                }
            }
        }
    }

    public static String getFieldData(String fieldData, int cIdx, int scIdx, HL7MessageInfo messageInfo) {
        if (cIdx == 0) {
            return fieldData;
        }
        return SegmentDataMapper.getComponentData(fieldData, cIdx, scIdx, messageInfo);
    }

    public static String getComponentData(String fieldData, int cIdx, int scIdx, HL7MessageInfo messageInfo) {
        String component;
        String[] components = StringHelper.split((String)fieldData, (String)messageInfo.getComponentSeparator());
        String string = component = components.length > --cIdx ? components[cIdx] : "";
        if (component.length() != 0 && scIdx != 0) {
            return SegmentDataMapper.getSubcomponentData(component, scIdx, messageInfo);
        }
        return component;
    }

    public static String getSubcomponentData(String fieldData, int scIdx, HL7MessageInfo messageInfo) {
        String[] subcomponents = StringHelper.split((String)fieldData, (String)messageInfo.getSubcomponentSeparator());
        return subcomponents.length > --scIdx ? subcomponents[scIdx] : "";
    }

    private int[] getIndices(String index) {
        int[] indices = new int[2];
        Arrays.fill(indices, 0);
        if (index != null && index.length() > 0) {
            String[] stringIndices = index.split("\\.");
            for (int i = 0; i < stringIndices.length; ++i) {
                indices[i] = Integer.parseInt(stringIndices[i]);
            }
        }
        return indices;
    }

    private String[] getFields(String text) {
        String[] raw = StringHelper.split((String)text, (String)this.messageInfo.getFieldDelimeter());
        String[] fields = null;
        if (raw[0].equals("MSH")) {
            fields = raw;
            fields[0] = this.messageInfo.getFieldDelimeter();
        } else {
            fields = new String[raw.length - 1];
            System.arraycopy(raw, 1, fields, 0, fields.length);
        }
        return fields;
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }
}

