/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.mapping.da;

import gov.va.med.hds.hdr.busobj.vhim.common.Template;
import gov.va.med.hds.hdr.common.util.StringHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.mapping.da.SegmentDataMapper;
import gov.va.med.hds.hdr.mapping.da.hl7.SegmentSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectAccessTemplateBuilder {
    private List segmentSpecifications;

    public Template buildTemplate(String message) {
        HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(message);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("messageInfo", messageInfo);
        SegmentDataMapper[] segments = this.identifySegments(StringHelper.split((String)message, (String)HL7MessageInfo.LINE_DELIMETER), (HL7MessageInfo)messageInfo, data);
        for (int i = 0; i < segments.length; ++i) {
            segments[i].executeInstructions();
        }
        return (Template)data.get("template");
    }

    public SegmentDataMapper[] identifySegments(String[] segs, HL7MessageInfo messageInfo, Map<String, Object> data) {
        Iterator iter = this.segmentSpecifications.iterator();
        SegmentSpecification ss = null;
        ArrayList<SegmentDataMapper> segments = new ArrayList<SegmentDataMapper>();
        for (int i = 0; i < segs.length; ++i) {
            while (iter.hasNext()) {
                ss = (SegmentSpecification)iter.next();
                if (!ss.matches(segs[i])) continue;
                iter = ss.getNexts().iterator();
                break;
            }
            if (ss == null) continue;
            SegmentDataMapper s = new SegmentDataMapper();
            s.setMessageInfo(messageInfo);
            s.setName(ss.getName());
            s.setSegmentSpecification(ss);
            s.setText(segs[i]);
            s.setData(data);
            segments.add(s);
            ss = null;
        }
        return segments.toArray(new SegmentDataMapper[segments.size()]);
    }

    public List getSegmentSpecifications() {
        return this.segmentSpecifications;
    }

    public void setSegmentSpecifications(List segmentSpecifications) {
        this.segmentSpecifications = segmentSpecifications;
    }
}

