/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.mapping.da;

import gov.va.med.hds.hdr.mapping.bean.BeanLinkerFactory;
import gov.va.med.hds.hdr.mapping.bean.BeanMutatorFactory;
import gov.va.med.hds.hdr.mapping.bean.BeanObjectFactory;
import gov.va.med.hds.hdr.mapping.bean.dyn.DynamicBeanObjectFactory;
import gov.va.med.hds.hdr.mapping.bean.dyn.DynamicBeanPropertyLinkerFactory;
import gov.va.med.hds.hdr.mapping.bean.dyn.DynamicBeanPropertyMutatorFactory;
import gov.va.med.hds.hdr.mapping.da.BeanPropertyNotFoundException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ByteCodeRegistry {
    private Map<String, BeanMutatorFactory> mutatorFactoryMap;
    private Map<String, BeanLinkerFactory> linkerFactoryMap;
    private Map<String, BeanObjectFactory> objectFactoryMap;
    private List register;

    public List getRegister() {
        return this.register;
    }

    public void setRegister(List register) throws Exception {
        this.register = register;
        this.init();
    }

    public BeanMutatorFactory getMutatorFactory(String key) {
        if (key != null) {
            Set<String> keys = this.mutatorFactoryMap.keySet();
            Iterator<String> iter = keys.iterator();
            String nextKey = null;
            while (iter.hasNext()) {
                nextKey = iter.next();
                if (!nextKey.startsWith(key)) continue;
                return this.mutatorFactoryMap.get(nextKey);
            }
        }
        throw new BeanPropertyNotFoundException("Mutator Factory", key);
    }

    public BeanLinkerFactory getLinkerFactory(String key) {
        BeanLinkerFactory factory = this.linkerFactoryMap.get(key);
        if (factory != null) {
            return factory;
        }
        throw new BeanPropertyNotFoundException("Linker Factory", key);
    }

    public BeanObjectFactory getObjectFactory(String key) {
        return this.objectFactoryMap.get(key);
    }

    private void init() throws Exception {
        this.objectFactoryMap = new Hashtable<String, BeanObjectFactory>();
        this.mutatorFactoryMap = new Hashtable<String, BeanMutatorFactory>();
        this.linkerFactoryMap = new Hashtable<String, BeanLinkerFactory>();
        Iterator iter = this.register.iterator();
        String cls = null;
        Class<?> c = null;
        while (iter.hasNext()) {
            cls = (String)iter.next();
            c = Class.forName(cls);
            BeanObjectFactory beanObjectFactory = DynamicBeanObjectFactory.createBeanObjectFactory(cls);
            this.objectFactoryMap.put(cls, beanObjectFactory);
            BeanInfo bi = Introspector.getBeanInfo(c);
            MethodDescriptor[] mds = bi.getMethodDescriptors();
            for (int i = 0; i < mds.length; ++i) {
                String methodName = mds[i].getName();
                Class<?>[] paramTypes = mds[i].getMethod().getParameterTypes();
                if (methodName.startsWith("set") && paramTypes.length == 1) {
                    String parameterType = paramTypes[0].getName();
                    String unqualParamtype = parameterType.substring(parameterType.lastIndexOf(46) + 1);
                    String propertyName = Introspector.decapitalize(methodName.substring(3));
                    BeanMutatorFactory mutatorFactory = DynamicBeanPropertyMutatorFactory.createBeanMutatorFactory(cls, methodName, parameterType);
                    this.mutatorFactoryMap.put(cls + "." + propertyName + "(" + unqualParamtype + ")", mutatorFactory);
                    continue;
                }
                if (!methodName.startsWith("add") || paramTypes.length != 1) continue;
                String linkedClassName = paramTypes[0].getName();
                String propertyName = Introspector.decapitalize(methodName.substring(3));
                BeanLinkerFactory linkerFactory = DynamicBeanPropertyLinkerFactory.createBeanLinkerFactory(cls, linkedClassName, methodName);
                this.linkerFactoryMap.put(cls + "." + propertyName, linkerFactory);
            }
        }
    }
}

