/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.manage.mbean;

import gov.va.med.hds.hdr.common.util.MBeanRegistrar;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class AbstractDynamicMBean
implements DynamicMBean {
    protected MBeanInfo mBeanInfo;
    protected Object host;
    protected Class hostClass;
    protected ObjectName mBeanName;
    private String[] attributeNames;
    private String[] operationNames;

    public AbstractDynamicMBean(Object host, Enum[] attributes, Enum[] operations) {
        int i;
        this.host = host;
        this.hostClass = !(host instanceof Class) ? host.getClass() : (Class)host;
        this.attributeNames = new String[attributes.length];
        this.operationNames = new String[operations.length];
        for (i = 0; i < attributes.length; ++i) {
            this.attributeNames[i] = attributes[i].name();
        }
        for (i = 0; i < operations.length; ++i) {
            this.operationNames[i] = operations[i].name();
        }
    }

    public abstract Object getAttribute(String var1) throws AttributeNotFoundException, MBeanException, ReflectionException;

    public AttributeList getAttributes(String[] attributes) {
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < this.attributeNames.length; ++i) {
            Object attributeValue = null;
            try {
                attributeValue = this.getAttribute(this.attributeNames[i]);
            }
            catch (Exception e) {
                attributeValue = new String(e.getLocalizedMessage());
            }
            attrList.add(new Attribute(this.attributeNames[i], attributeValue));
        }
        return attrList;
    }

    protected abstract void buildDynamicMBeanInfo();

    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public void register() {
        try {
            this.mBeanName = MBeanRegistrar.createObjectName("requestHandlerPool", this, new String[][]{{"theadName", Thread.currentThread().getName()}});
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        MBeanRegistrar.registerMBean(this.mBeanName, (Object)this);
    }

    public void unregister() {
        MBeanRegistrar.unregisterMBean(this.mBeanName);
    }
}

