/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.vdef.broker;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.xslt.XSLTAdapterFactory;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.rpc.broker.ER7RequestBroker;
import gov.va.med.hds.hdr.common.rpc.broker.InvalidParameterException;
import gov.va.med.hds.hdr.common.rpc.broker.InvocationException;
import gov.va.med.hds.hdr.common.rpc.broker.RequestBroker;
import gov.va.med.hds.hdr.loader.IMSLoader;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterFactory;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class VDEFRequestBroker
implements RequestBroker {
    private static final String XP_BROKERCONFIG = "transformer/vdefbroker/entry-point[@code='CODE']";
    private static final String XP_DESTINATIONS = "transformer/vdefbroker/entry-point[@code='CODE']/destinations/destination";
    private static final String XP_TEMPLATE = "transformer/mapping-type-codes/mapping-type-code[@message-type='MESSAGE_TYPE']/@template";
    private static final String XP_SENDING_APPLICATION = "//graph/instance[@role='vdef' and @type='VDEF']/attribute[@name='sendingApplication' and @type='PlainText']/field[@name='value']";
    private static final String XP_SENDING_FACILITY_ID = "//graph/instance[@role='vdef' and @type='VDEF']/attribute[@name='sendingFacilityId' and @type='PlainText']/field[@name='value']";
    private static final String XP_SENDING_FACILITY_DOMAIN = "//graph/instance[@role='vdef' and @type='VDEF']/attribute[@name='sendingFacilityDomain' and @type='PlainText']/field[@name='value']";
    private static final String XP_RECEIVING_APPLICATION = "//graph/instance[@role='vdef' and @type='VDEF']/attribute[@name='receivingApplication' and @type='PlainText']/field[@name='value']";
    private static final String XP_RECEIVING_FACILITY_ID = "//graph/instance[@role='vdef' and @type='VDEF']/attribute[@name='receivingFacilityId' and @type='PlainText']/field[@name='value']";
    private static final String XP_RECEIVING_FACILITY_DOMAIN = "//graph/instance[@role='vdef' and @type='VDEF']/attribute[@name='receivingFacilityDomain' and @type='PlainText']/field[@name='value']";
    private static final String XP_MESSAGE_CONTROL_ID = "//graph/instance[@role='vdef' and @type='VDEF']/attribute[@name='messageControlId' and @type='PlainText']/field[@name='value']";
    private static final PropertyMgr propertyMgr = PropertyMgr.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer invoke(ByteBuffer bMessage) {
        ByteBuffer response = ByteBuffer.wrap("".getBytes());
        String message = new String(bMessage.array());
        try {
            PropertyElement[] destinations;
            int mshIdx = message.indexOf("MSH");
            if (mshIdx != -1 && mshIdx != 0) {
                message = message.substring(mshIdx);
            }
            ResultAdapter resultAdapter = ResultAdapterFactory.createResultAdapter(message);
            String messageType = resultAdapter.getMessageType(message);
            String templateName = null;
            PropertyElement rpcTemplateElement = propertyMgr.getProperty(XP_TEMPLATE.replaceAll("MESSAGE_TYPE", messageType));
            if (rpcTemplateElement == null || (templateName = rpcTemplateElement.getValue()).length() == 0) {
                throw new InvocationException("Error finding template for message type: " + messageType);
            }
            Document requestDocument = (Document)resultAdapter.adapt(message, templateName);
            Element sendingApplication = VDEFRequestBroker.getDocumentElement(requestDocument, XP_SENDING_APPLICATION, true);
            Element sendingFacilityId = ER7RequestBroker.getDocumentElement(requestDocument, XP_SENDING_FACILITY_ID, false);
            Element sendingFacilityDomain = ER7RequestBroker.getDocumentElement(requestDocument, XP_SENDING_FACILITY_DOMAIN, false);
            Element receivingApplication = VDEFRequestBroker.getDocumentElement(requestDocument, XP_RECEIVING_APPLICATION, false);
            Element receivingFacilityId = ER7RequestBroker.getDocumentElement(requestDocument, XP_RECEIVING_FACILITY_ID, false);
            Element receivingFacilityDomain = ER7RequestBroker.getDocumentElement(requestDocument, XP_RECEIVING_FACILITY_DOMAIN, false);
            Element originalMessageControlId = VDEFRequestBroker.getDocumentElement(requestDocument, XP_MESSAGE_CONTROL_ID, true);
            String code = sendingFacilityDomain.getText().indexOf("MED.VA.GOV") != -1 ? "VISTA" : "CHDR";
            PropertyElement brokerConfig = propertyMgr.getProperty(XP_BROKERCONFIG.replaceFirst("CODE", code));
            if (brokerConfig == null) {
                throw new InvocationException("Error finding broker configuration for code: " + code);
            }
            String stylesheet = "../templates/vdef/Acknowledge.xsl";
            PropertyElement[] pes = brokerConfig.getChildProperties("stylesheet");
            if (pes != null && pes.length == 1) {
                stylesheet = pes[0].getValue();
            }
            if ((destinations = propertyMgr.getProperties(XP_DESTINATIONS.replaceFirst("CODE", code))) != null && destinations.length > 0) {
                for (PropertyElement destination : destinations) {
                    Connection c = null;
                    try {
                        c = DataSourceManager.getInstance().getDataSource(destination.getAttribute("datasource")).getConnection();
                        if (!"CHDR".equals(code)) {
                            IMSLoader.writeMessage((Connection)c, (String)message);
                        } else {
                            IMSLoader.writeMessage((Connection)c, (String)message, (String)"C");
                        }
                        c.commit();
                    }
                    finally {
                        if (c != null) {
                            try {
                                c.close();
                            }
                            catch (SQLException sqle) {
                                IMSException.getIMSException("Error closing QUEUES connection.", sqle);
                            }
                        }
                    }
                }
            }
            DocumentFactory df = DocumentFactory.getInstance();
            Document vdef = df.createDocument();
            Element root = df.createElement("vdef");
            vdef.setRootElement(root);
            Element sender = df.createElement("sender");
            Element senderApplication = df.createElement("application");
            Element senderFacility = df.createElement("facility");
            Element senderFacilityId = df.createElement("id");
            Element senderFacilityDomain = df.createElement("domain");
            Element receiver = df.createElement("receiver");
            Element receiverApplication = df.createElement("application");
            Element receiverFacility = df.createElement("facility");
            Element receiverFacilityId = df.createElement("id");
            Element receiverFacilityDomain = df.createElement("domain");
            Element messageDateTime = df.createElement("message-date-time");
            Element origMessageControlId = df.createElement("orig-message-control-id");
            root.add(sender);
            sender.add(senderApplication);
            sender.add(senderFacility);
            senderFacility.add(senderFacilityId);
            senderFacility.add(senderFacilityDomain);
            root.add(receiver);
            receiver.add(receiverApplication);
            receiver.add(receiverFacility);
            receiverFacility.add(receiverFacilityId);
            receiverFacility.add(receiverFacilityDomain);
            root.add(messageDateTime);
            root.add(origMessageControlId);
            senderApplication.setText(sendingApplication.getText());
            senderFacilityId.setText(sendingFacilityId.getText());
            senderFacilityDomain.setText(sendingFacilityDomain.getText());
            receiverApplication.setText(receivingApplication.getText());
            receiverFacilityId.setText(receivingFacilityId.getText());
            receiverFacilityDomain.setText(receivingFacilityDomain.getText());
            messageDateTime.setText(DateTimeUtility.getCurrentTime());
            origMessageControlId.setText(originalMessageControlId.getText());
            Adapter responseAdapter = new XSLTAdapterFactory(stylesheet).createAdapter();
            responseAdapter.setInput(vdef);
            responseAdapter.adapt();
            response = ByteBuffer.wrap(((String)responseAdapter.getResult()).getBytes());
        }
        catch (Exception e) {
            IMSException.getIMSException(e, (CharSequence)message, "Error writing message to queue.");
        }
        return response;
    }

    public static Element getDocumentElement(Document requestDocument, String requestElement, boolean requiredElement) throws InvalidParameterException {
        Element element = (Element)requestDocument.selectSingleNode(requestElement);
        if (requiredElement && null == element && requiredElement && null == element) {
            throw new InvalidParameterException("Element not found in request: " + requestElement);
        }
        return element;
    }
}

