/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.transformer.systemcontrol.Transformer;
import gov.va.med.hds.hdr.common.util.FrameworkControlException;
import gov.va.med.hds.hdr.common.util.FrameworkProcessControl;
import gov.va.med.hds.hdr.common.util.GetArgs;
import java.io.File;
import java.util.ArrayList;

public class TransformerControl
extends FrameworkProcessControl {
    private static final String syncString = Transformer.class.getName() + " started:";

    public TransformerControl(boolean start, boolean debug, String javaArgs) {
        super(start ? syncString : null);
        String cp = "config:lib/common.jar:lib/fhie.jar:lib/fhieidl.jar:lib/mail.jar:lib/activation.jar:lib/xmlparserv2.jar:lib/tools.jar:lib/log4j-1.2.jar:lib/jaas.jar:lib/loghandlers.jar:lib/externalutils.jar:lib/java-getopt-1.0.9.jar:lib/ojdbc14.jar:lib/tools.jar:lib/commons-logging.jar:lib/aqapi13.jar:lib/commons-collections-3.1.jar:lib/commons-dbcp-1.2.1.jar:lib/commons-pool-1.2.jar";
        this.cmdCol = new ArrayList();
        this.cmdCol.add(this.javaHome + "/bin/java");
        this.cmdCol.add("-server");
        this.cmdCol.add("-Xbootclasspath/p:" + this.ORBlibs);
        if (null == javaArgs || 0 == javaArgs.length()) {
            this.cmdCol.add("-Xms1024m");
            this.cmdCol.add("-Xmx2048m");
        } else {
            String[] jArgs = javaArgs.split(",");
            int arrLen = jArgs.length;
            for (int i = 0; i < arrLen; ++i) {
                this.cmdCol.add(jArgs[i].trim());
            }
        }
        if (start) {
            this.cmdCol.add("-Dims.module=Transformer");
            this.cmdCol.add("-jar");
            this.cmdCol.add(this.cwd + "/lib/fhie.jar");
            this.cmdCol.add("-svc_name");
            this.cmdCol.add("tfmr_all_1");
            this.cmdCol.add("-out");
            this.cmdCol.add("Transformer.out");
            this.cmdCol.add("-err");
            this.cmdCol.add("Transformer.err");
        } else {
            this.cmdCol.add("-classpath");
            this.cmdCol.add(cp);
            this.cmdCol.add("gov.fhie.common.util.JmsClient");
            this.cmdCol.add("IMS_ADMIN_MSG_Q");
            this.cmdCol.add("SHUTDOWN");
        }
        this.init(debug);
    }

    public void shutdownProcess(String pid) throws Exception {
        Process shutdownProc = null;
        try {
            System.out.println("\tTransformer attempting graceful shutdown...");
            File dir = new File(this.getInitialDir());
            shutdownProc = Runtime.getRuntime().exec(this.cmdCol.toArray(new String[this.cmdCol.size()]), null, dir);
            shutdownProc.waitFor();
            if (!this.monitorProcess(pid, 15)) {
                throw new FrameworkControlException("Graceful shutdown failed.");
            }
        }
        catch (Exception e) {
            System.out.println("\tTransformer: " + e.getLocalizedMessage() + "\n\tKilling Transformer process (" + pid + ").");
            super.shutdownProcess(pid);
        }
    }

    public void run() {
        try {
            this.startProcess();
            while (null != this.getProcessObject() && !this.isStarted()) {
                TransformerControl.yield();
                TransformerControl.sleep(2000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSymbolicName() {
        return Transformer.class.getName();
    }

    public static void main(String[] args) {
        GetArgs getOpts;
        boolean start = true;
        start = getOpts.getUnaryOpt("start", !(getOpts = new GetArgs(TransformerControl.class, args, "pid:J", "start:shutdown:debug")).getUnaryOpt("shutdown"));
        TransformerControl transformer = new TransformerControl(start, getOpts.getUnaryOpt("debug"), getOpts.getArg("J", null));
        if (start) {
            transformer.start();
            while (transformer.isAlive()) {
                TransformerControl.yield();
                try {
                    TransformerControl.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Process transProc = transformer.getProcessObject();
            if (null == transProc) {
                System.out.println("Transformer failed to start.");
                System.exit(1);
            } else {
                System.out.println("Transformer has been started.");
            }
        } else {
            try {
                transformer.shutdownProcess(getOpts.getArg("pid"));
            }
            catch (Exception e) {
                System.err.println("Transformer shutdown failure:");
                e.printStackTrace();
            }
        }
    }
}

