/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.util.StdinListener;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.util.Date;

public abstract class StdinProcessor
extends Thread {
    private static final String OS_NAME = System.getProperty("os.name");
    private final String EOL = System.getProperty("line.separator");
    private static final String USER_DIR = System.getProperty("user.dir") + "/";
    private static final String APP_NAME = System.getProperty("ims.module");
    private static final String DEFAULT_PIPE_NAME = "log/.stdin";
    protected static String pipeName = "log/.stdin";
    private StringBuffer sb = new StringBuffer();
    private byte[] b = new byte[128];
    private ByteBuffer buf = ByteBuffer.wrap(this.b);
    private StdinListener stdin;
    protected final Date startTime = new Date(System.currentTimeMillis());

    public StdinProcessor(String threadName) {
        super("StdinProcessor::" + threadName);
        this.setDaemon(true);
    }

    protected boolean execute(String cmd) {
        System.out.println("\n>>>>>> " + this.startTime.toString() + " <<<<<<");
        return cmd.endsWith(this.EOL);
    }

    public void setPipeName(String pipeName) {
        StdinProcessor.pipeName = pipeName;
    }

    public String getPipeName() {
        return this.stdin.getPipeName();
    }

    private void snooze(long millis) {
        try {
            StdinProcessor.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String normalize(String name) {
        if (null != name) {
            StringBuffer normalized = new StringBuffer(name.trim().toLowerCase());
            if (!normalized.toString().matches("(?:/|\\\\).+")) {
                normalized.insert(0, USER_DIR);
            }
            return normalized.toString();
        }
        return pipeName;
    }

    private void getProperties() {
        PropertyElement pe;
        String mkfifoCmd = "mkfifo -p";
        PropertyMgr pm = PropertyMgr.getInstance();
        if (null != pm && null != (pe = pm.getProperty("/properties/node/*[@app_name='" + APP_NAME + "']/namedpipe")) && !pe.isEmpty()) {
            pipeName = this.normalize(pe.getAttribute("name"));
            mkfifoCmd = pe.getAttribute("command");
        }
        if (null != mkfifoCmd && 0 != mkfifoCmd.length()) {
            StdinListener.setMkfifo(new StringBuffer(mkfifoCmd).append(" ").append(pipeName).toString());
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.getProperties();
                    this.stdin = new StdinListener(pipeName);
                    Pipe.SourceChannel wormHole = this.stdin.getWormHole();
                    this.stdin.setDaemon(true);
                    this.stdin.start();
                    int len = 0;
                    while (-1 != (len = wormHole.read(this.buf))) {
                        if (0 == len) {
                            this.snooze(500L);
                        } else {
                            this.sb.append(new String(this.buf.array(), 0, len));
                        }
                        if (this.execute(this.sb.toString())) {
                            this.sb.setLength(0);
                        }
                        this.buf.clear();
                        StdinProcessor.yield();
                    }
                    if (this.execute(this.sb.toString())) {
                        this.sb.setLength(0);
                    }
                    this.snooze(5000L);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.exit(2);
                continue;
            }
            break;
        }
    }

    public void open$In(String pipeName) {
        if (!OS_NAME.startsWith("Windows")) {
            this.setDaemon(true);
            this.setPipeName(pipeName);
            this.start();
            this.snooze(500L);
            if (null != this.stdin) {
                System.out.println("Reading stdin from " + this.getPipeName());
            }
        }
    }
}

