/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;

public class StdinListener
extends Thread {
    private static String mkfifoCmd = "/usr/bin/mkfifo -p log/.stdin";
    private static Pipe wormHole;
    private static Pipe.SinkChannel drain;
    private File pipe;

    public StdinListener(String pipeName) throws IOException, InterruptedException {
        this.init(new File(pipeName));
    }

    public StdinListener(File pipe) throws IOException, InterruptedException {
        this.init(pipe);
    }

    public StdinListener() throws IOException, InterruptedException {
        this.init(new File("log/.stdin"));
    }

    public static void setMkfifo(String mkfifoCmd) {
        if (null != mkfifoCmd) {
            StdinListener.mkfifoCmd = mkfifoCmd;
        }
    }

    private void init(File pipe) throws IOException, InterruptedException {
        this.pipe = pipe.getCanonicalFile();
        wormHole = SelectorProvider.provider().openPipe();
        drain = wormHole.sink();
        if (!pipe.exists()) {
            Process mkfifo = Runtime.getRuntime().exec(mkfifoCmd);
            BufferedInputStream bis = new BufferedInputStream(mkfifo.getInputStream());
            int rslt = mkfifo.waitFor();
            if (0 != rslt) {
                int len = 0;
                byte[] b = new byte[Math.max(bis.available(), 128)];
                while (-1 != (len = bis.read(b))) {
                    System.out.print(new String(b, 0, len));
                }
                throw new IOException("Failed to created named pipe (Completion code=" + rslt + "): " + mkfifoCmd);
            }
        }
    }

    public Pipe.SourceChannel getWormHole() {
        return wormHole.source();
    }

    private void openNamedPipe() {
        FileInputStream fis = null;
        while (null == fis) {
            try {
                fis = new FileInputStream(this.pipe);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                fis = null;
                this.snooze(5000L);
            }
        }
        System.setIn(fis);
    }

    private void closeNamedPipe() {
        try {
            if (null != System.in) {
                System.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void snooze(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getPipeName() {
        try {
            return this.pipe.getCanonicalPath();
        }
        catch (IOException e) {
            return this.pipe.getAbsolutePath();
        }
    }

    public void run() {
        byte[] write = null;
        byte[] read = new byte[128];
        this.setName("StdinListener[" + this.getId() + "]");
        this.openNamedPipe();
        int len = 0;
        try {
            while (true) {
                try {
                    while (true) {
                        if (-1 != (len = System.in.read(read))) {
                            write = new byte[len];
                            System.arraycopy(read, 0, write, 0, len);
                            drain.write(ByteBuffer.wrap(write));
                            StdinListener.yield();
                            continue;
                        }
                        this.snooze(3000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.closeNamedPipe();
                    this.openNamedPipe();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.closeNamedPipe();
            throw throwable;
        }
    }
}

