/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;

public class SqlUtil {
    public static final String SCHEMA_HL7_PLUS = "hl7_plus";
    public static final String SCHEMA_MPI = "mpi";
    public static final String SCHEMA_LOG_PLUS = "log_plus";
    public static final String SCHEMA_HDR = "hdr";
    public static final String SCHEMA_IMS = "ims";
    public static final String SCHEMA_COMMON = "common";
    public static final String SCHEMA_LAB = "lab";
    public static final String SCHEMA_CACHE_PLUS = "cache_plus";
    private static final StringBuffer params = new StringBuffer("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,??,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
    private static final Properties schemas = new Properties();

    public static final String getSchemaFor(String schemaName) {
        return schemas.getProperty(schemaName.toLowerCase(), "");
    }

    public static final String getSchemaFor(String schemaName, String delimiter) {
        String schema = schemas.getProperty(schemaName.toLowerCase(), "");
        return 0 < schema.length() ? schema + delimiter : schema;
    }

    public static final String fillParams(int length) {
        int start = params.length() - (length + (length - 1));
        return 0 < start ? params.substring(start) : params.toString();
    }

    public static void setPreparedStatmentString(PreparedStatement pstmt, int index, String value) throws SQLException {
        if (value != null) {
            pstmt.setString(index, value);
        } else {
            pstmt.setNull(index, 12);
        }
    }

    public static void setPreparedStatementTimestamp(PreparedStatement pstmt, int index, String isoFormattedDate) throws SQLException {
        if (isoFormattedDate != null && isoFormattedDate.length() != 0) {
            Timestamp clinicalDate = new Timestamp(DateTimeUtility.getMilliSecond(isoFormattedDate));
            pstmt.setTimestamp(index, clinicalDate, Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        } else {
            pstmt.setNull(index, 93);
        }
    }

    public static void main(String[] args) {
        String[] messageType = new String[]{"AAAA", "BBBB", "CCCC"};
        String[] pids = new String[]{"1234", "4567"};
        StringBuffer sb = new StringBuffer("select  latest_clinical_date, record_number, message, message_ty from pdts_repository where  active='Y' and local_pid in (");
        sb.append(SqlUtil.fillParams(pids.length));
        sb.append(") and message_insertion_time>=? and message_insertion_time<?");
        if (messageType != null) {
            sb.append(" and message_type in (" + SqlUtil.fillParams(messageType.length) + ")");
        }
        int iterations = 5000000;
        long startA = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            SqlUtil.fillParams(i % 50 + 1);
        }
        long oElapsed = System.currentTimeMillis() - startA;
        System.out.println("fillParamsS Overall elapsed: " + oElapsed);
        System.out.println("fillParamsS Overall average: " + oElapsed / (long)iterations);
    }

    static {
        PropertyMgr pm = PropertyMgr.getInstance();
        PropertyElement[] schemaProperties = pm.getProperties("schemas/schema");
        if (null != schemaProperties && 0 < schemaProperties.length) {
            for (PropertyElement schemaProperty : schemaProperties) {
                schemas.put(schemaProperty.getAttribute("name").trim().toLowerCase(), schemaProperty.getAttribute("schema").trim().toLowerCase());
            }
        }
    }
}

