/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class RegularExpressionHelper {
    private static final String ESC_CHAR = "\\";
    private static final String SEP_FIELD = "|";
    private static final String SEP_REPEAT = "~";
    private static final String SEP_COMPONENT = "^";
    private static final String SEP_SUBCOMPONENT = "&";
    private static final List SPECIAL_CHARS = Arrays.asList("[", "\\", "^", "$", ".", "|", "?", "*", "+", "(", ")");

    public static String escape(String unEscaped) {
        StringBuilder escaped = new StringBuilder();
        char[] chars = unEscaped.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] - 91 == 0 || chars[i] - 92 == 0 || chars[i] - 94 == 0 || chars[i] - 36 == 0 || chars[i] - 46 == 0 || chars[i] - 124 == 0 || chars[i] - 43 == 0 || chars[i] - 63 == 0 || chars[i] - 42 == 0 || chars[i] - 40 == 0 || chars[i] - 41 == 0) {
                escaped.append(ESC_CHAR);
            }
            escaped.append(chars[i]);
        }
        return escaped.toString();
    }

    public static String genericToMessageSpecific(HL7MessageInfo messageInfo, String regEx) {
        String append = null;
        boolean bEscaped = false;
        char[] expression = regEx.toCharArray();
        regEx = "";
        Hashtable<String, String> swapMap = new Hashtable<String, String>();
        if (!SEP_FIELD.equals(messageInfo.getFieldDelimeter())) {
            swapMap.put(SEP_FIELD, messageInfo.getFieldDelimeter());
        }
        if (!SEP_REPEAT.equals(messageInfo.getRepetitionSeparator())) {
            swapMap.put(SEP_REPEAT, messageInfo.getRepetitionSeparator());
        }
        if (!SEP_COMPONENT.equals(messageInfo.getComponentSeparator())) {
            swapMap.put(SEP_COMPONENT, messageInfo.getComponentSeparator());
        }
        if (!SEP_SUBCOMPONENT.equals(messageInfo.getSubcomponentSeparator())) {
            swapMap.put(SEP_SUBCOMPONENT, messageInfo.getSubcomponentSeparator());
        }
        for (int i = 0; i < expression.length; ++i) {
            char c = expression[i];
            if (!bEscaped && (bEscaped = ESC_CHAR.equals(c + ""))) continue;
            if (SPECIAL_CHARS.contains(c + "")) {
                if (bEscaped) {
                    append = (String)swapMap.get(c + "");
                    append = append != null ? append : c + "";
                    append = SPECIAL_CHARS.contains(c + "") ? ESC_CHAR + append : append;
                    regEx = regEx + append;
                    bEscaped = false;
                    continue;
                }
                regEx = regEx + c + "";
                continue;
            }
            append = (String)swapMap.get(c + "");
            append = append != null ? append : c + "";
            append = SPECIAL_CHARS.contains(c + "") ? ESC_CHAR + append : append;
            regEx = regEx + append;
        }
        return regEx;
    }
}

