/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.util.GetArgs;
import gov.va.med.hds.hdr.common.util.SqlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.OracleDriver;

public class QueryRepository {
    private final String schemaHL7_PLUS = SqlUtil.getSchemaFor("hl7_plus", ".");
    private static final String queryRepositoryByTyTemplate = "select count(*) from {0}hl7_repository where message_ty=? and local_pid=? and pid_domain=?";
    private final String queryRepositoryByTy;
    private final String javaHome = System.getProperty("java.home");
    private final String lineSep = System.getProperty("line.separator");
    private final char pathSep = System.getProperty("path.separator").charAt(0);
    private final String cp = ".:lib/common.jar:lib/fhie.jar:lib/fhieidl.jar:lib/mail.jar:lib/activation.jar:lib/log4j-1.2.jar:lib/jaas.jar:lib/ojdbc14.jar:cots/Orbacus-4.1.2/lib/OB.jar:cots/Orbacus-4.1.2/lib/OBNaming.jar:lib/jdom.jar:lib/saxpath.jar:lib/jaxen-full.jar:jms.jar".replace(':', this.pathSep);
    private final String bcp = "cots/Orbacus-4.1.2/lib/OB.jar:cots/Orbacus-4.1.2/lib/OBNaming.jar".replace(':', this.pathSep);
    private final String command = this.javaHome + "/bin/java";
    private final String[] debugArgs = new String[]{"-Xrunjdwp:transport=dt_socket,server=y,address=8010,suspend=y", "-Xdebug", "-Xnoagent"};
    private final String[] cmdArgs = new String[]{"-Xbootclasspath/p:" + this.bcp, "-classpath", this.cp, "gov.fhie.transformer.test.QueryAccessTester"};
    private String sessionParams = "test/sessionparams.txt";
    private String testDate = new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime());
    private String url;
    private String user;
    private String passwd;
    private String cwd = System.getProperty("user.dir");
    private String qaTemplate;
    private Connection conn;
    private static boolean debug = false;
    private static boolean includeEmptySet = false;
    private static boolean keep = false;
    private String[][] templateTypes = null;

    public QueryRepository(String domain) {
        this.getProperties(domain);
        this.conn = this.openConnection();
        this.queryRepositoryByTy = MessageFormat.format(queryRepositoryByTyTemplate, this.schemaHL7_PLUS);
    }

    public QueryRepository(String domain, String testDate, String cwd, String sessionParams) {
        if (null != testDate) {
            this.testDate = testDate;
        }
        if (null != cwd) {
            this.cwd = cwd;
        }
        if (null != sessionParams) {
            this.sessionParams = sessionParams;
        }
        this.getProperties(domain);
        this.conn = this.openConnection();
        this.queryRepositoryByTy = MessageFormat.format(queryRepositoryByTyTemplate, this.schemaHL7_PLUS);
    }

    private Connection openConnection() {
        Connection conn = null;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            conn = DriverManager.getConnection(this.url, this.user, this.passwd);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    private void readQAParamTemplate() throws Exception {
        StringBuffer qaparams = new StringBuffer();
        BufferedReader qaparamFile = new BufferedReader(new FileReader("test/qaparams.tplt"));
        String line = null;
        while (null != (line = qaparamFile.readLine())) {
            qaparams.append(line + this.lineSep);
        }
        this.qaTemplate = qaparams.toString().replaceAll("\\[db_url\\]", this.url).replaceAll("\\[end_date\\]", this.testDate);
    }

    private synchronized String createQAParamFile(String icn, String templateName) throws Exception {
        String fName = "test/" + this.testDate + "." + icn + "." + templateName.substring(templateName.lastIndexOf(47) + 1);
        File tFile = new File(fName + ".txt");
        int i = 0;
        while (tFile.exists()) {
            fName = fName + "." + ++i;
            tFile = new File(fName + ".txt");
        }
        System.err.println(fName);
        if (null == this.qaTemplate) {
            this.readQAParamTemplate();
        }
        String contents = this.qaTemplate.replaceAll("\\[pid\\]", icn).replaceAll("\\[template_name\\]", templateName).replaceAll("\\[outfile\\]", fName + ".out");
        FileWriter tmpltFile = new FileWriter(tFile);
        tmpltFile.write(contents);
        tmpltFile.flush();
        tmpltFile.close();
        return fName + ".txt";
    }

    private void getProperties(String domain) {
        String PROPERTY_FILE = "fhie_properties.xml";
        PropertyMgr properties = new PropertyMgr("fhie_properties.xml", "/properties/node/transformer[@id='tfmr_all_1']/datasources/datasource[@id='" + domain + "']");
        this.url = properties.getProperty("property[@name='url']/@value").getValue();
        this.user = properties.getProperty("property[@name='username']/@value").getValue();
        this.passwd = properties.getProperty("property[@name='password']/@value").getValue();
        properties = new PropertyMgr("/properties/node/transformer");
        PropertyElement[] supportedTypes = properties.getProperties("mapping-type-codes/mapping-type-code[not(contains(@message-type,'_CLI'))]");
        if (0 < supportedTypes.length) {
            this.templateTypes = new String[supportedTypes.length][2];
            for (int i = 0; i < supportedTypes.length; ++i) {
                PropertyElement template = supportedTypes[i];
                this.templateTypes[i][0] = template.getAttribute("message-type");
                this.templateTypes[i][1] = template.getAttribute("template");
            }
        }
    }

    private void openStdIO(final Process proc) {
        final InputStream[] stdio = new InputStream[]{new BufferedInputStream(proc.getInputStream()), new BufferedInputStream(proc.getErrorStream())};
        for (int i = 0; i < stdio.length; ++i) {
            new Thread(proc.toString() + (i == 0 ? ".stdout" : ".stderr")){
                Process myProc;
                String threadName;
                String ioType;
                BufferedInputStream io;
                {
                    super(x0);
                    this.myProc = proc;
                    this.threadName = this.getName();
                    this.ioType = this.threadName.substring(this.threadName.lastIndexOf(46) + 1);
                    this.io = (BufferedInputStream)stdio[this.ioType.equals("stdout") ? 0 : 1];
                }

                public void run() {
                    byte[] b = null;
                    int cnt = 0;
                    while (true) {
                        try {
                            this.myProc.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            1.yield();
                            try {
                                b = new byte[this.io.available()];
                                cnt = this.io.read(b);
                                if (0 < cnt) {
                                    if (this.ioType.equals("stdout")) {
                                        String str = new String(b);
                                        String regex = ".+ (Returned (\\d+) results\\.)$.*";
                                        Matcher matcher = Pattern.compile(regex, 40).matcher(str);
                                        boolean matched = matcher.matches();
                                        if (!matched) continue;
                                        System.out.println(matcher.group(1));
                                        continue;
                                    }
                                    System.err.print(new String(b));
                                    continue;
                                }
                                try {
                                    Thread.sleep(1500L);
                                }
                                catch (InterruptedException e1) {}
                                continue;
                            }
                            catch (IOException ioe) {
                                try {
                                    this.io.close();
                                    cnt = -1;
                                    continue;
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (-1 != cnt) continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    private void executeQueryThreads(Iterator icnIter) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Thread repQuery = null;
        boolean cnt = false;
        while (icnIter.hasNext()) {
            final icnStuff stuff = (icnStuff)icnIter.next();
            if (0 < stuff.size()) {
                repQuery = new Thread(stuff.getIcn()){
                    icnStuff lStuff;
                    ArrayList<String> cmd;
                    {
                        super(x0);
                        this.lStuff = stuff;
                        this.cmd = new ArrayList();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        this.cmd.add(QueryRepository.this.command);
                        if (debug) {
                            this.cmd.addAll(Arrays.asList(QueryRepository.this.debugArgs));
                        }
                        this.cmd.addAll(Arrays.asList(QueryRepository.this.cmdArgs));
                        this.cmd.add(QueryRepository.this.sessionParams);
                        Runtime rt = Runtime.getRuntime();
                        Iterator itStuff = this.lStuff.iterator();
                        while (itStuff.hasNext()) {
                            Map.Entry element = (Map.Entry)itStuff.next();
                            String fName = null;
                            Process query = null;
                            try {
                                String key = (String)element.getKey();
                                fName = QueryRepository.this.createQAParamFile(this.getName(), key);
                                this.cmd.add(fName);
                                query = rt.exec(this.cmd.toArray(new String[this.cmd.size()]), null, new File(QueryRepository.this.cwd));
                                QueryRepository.this.openStdIO(query);
                                query.waitFor();
                                this.cmd.remove(fName);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                if (null == query) continue;
                                query.destroy();
                            }
                        }
                    }
                };
                repQuery.start();
            }
            threads.add(repQuery);
        }
        Iterator iter = threads.iterator();
        while (iter.hasNext()) {
            try {
                repQuery = (Thread)iter.next();
                if (!repQuery.isAlive()) continue;
                repQuery.join();
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryRepository(BufferedReader icnList) {
        File testDir;
        File[] files;
        ArrayList<icnStuff> incs = new ArrayList<icnStuff>();
        String line = null;
        Pattern icnPattern = Pattern.compile("^\\d+ \\(((\\d+)V(\\d+))\\)$");
        try {
            while (null != (line = icnList.readLine())) {
                Matcher icnMatch = icnPattern.matcher(line);
                if (!icnMatch.find()) continue;
                String icn = icnMatch.group(1);
                String pid = icnMatch.group(2);
                String facility = "MED.VA.GOV/" + icnMatch.group(3);
                icnStuff stuff = new icnStuff(icn);
                Object type = null;
                ResultSet rslt = null;
                for (int i = 0; i < this.templateTypes.length; ++i) {
                    try {
                        PreparedStatement stmt = this.conn.prepareStatement(this.queryRepositoryByTy);
                        stmt.setString(1, this.templateTypes[i][0]);
                        stmt.setString(2, pid);
                        stmt.setString(3, facility);
                        rslt = stmt.executeQuery();
                        if (!rslt.next()) continue;
                        int count = 0;
                        if (!includeEmptySet && 0 >= (count = rslt.getInt(1))) continue;
                        stuff.setCount(this.templateTypes[i][1], count);
                        continue;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        try {
                            rslt.close();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                            try {
                                this.conn.close();
                                System.exit(1);
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                }
                if (0 >= stuff.size()) continue;
                incs.add(stuff);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                icnList.close();
            }
            catch (IOException e1) {}
        }
        if (0 < incs.size()) {
            this.executeQueryThreads(incs.iterator());
        }
        if (!keep && null != this.templateTypes && 0 != this.templateTypes.length && null != (files = (testDir = new File("./test")).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.endsWith(".out.txt") && name.endsWith(".txt")) {
                    for (int i = 0; i < QueryRepository.this.templateTypes.length; ++i) {
                        String tpltName = QueryRepository.this.templateTypes[i][1].split("/")[1];
                        if (-1 == name.indexOf(tpltName)) continue;
                        return true;
                    }
                }
                return false;
            }
        })) && 0 < files.length) {
            for (int i = 0; i < files.length; ++i) {
                files[i].deleteOnExit();
            }
        }
    }

    public static void usage() {
        System.err.println("java gov.va.med.hds.hdr.test.smoketest.QueryRepository -i icnlist -d domain [-t date] [-p path] [-s session] [-e] [-debug] [-keep]\n");
        System.err.println("\t-i icnlist - the name of the file containing a list of icns to\n\t             query for.");
        System.err.println("\t-d domain  - the domain in which to test (e.g. fhie.gov/va0).");
        System.err.println("\t-t date    - value for END_DATE in the parameter file. (Default: current date)");
        System.err.println("\t-p path    - the initial working directory.  All interally generated\n\t             paths will be relative to this. (Default: directory in which\n\t             the program is started)");
        System.err.println("\t-s session - the name of the session parameter file.  This should be defined\n\t             relative to the value of -p. (Default: test/sessionparams.txt");
        System.err.println("\t-e         - include all templates, even those for which there is no\n\t             data stored. (Default: no empty templates)");
        System.err.println("\t-debug     - start the process and wait for a debugger to attach before\n\t             continuing. (Default: debug off)");
        System.err.println("\t-keep      - keep the generated param files. (Default: don't keep files)");
        System.exit(1);
    }

    public static void main(String[] args) {
        GetArgs getOpts = new GetArgs(QueryRepository.class, args, "i:d:t:p:s", "e:debug:keep", "i:d");
        String icnListFile = getOpts.getArg("i", null);
        String domain = getOpts.getArg("d", null);
        String testDate = getOpts.getArg("t", null);
        String cwd = getOpts.getArg("p", null);
        String sessionParams = getOpts.getArg("s", null);
        includeEmptySet = getOpts.getUnaryOpt("e");
        debug = getOpts.getUnaryOpt("debug");
        keep = getOpts.getUnaryOpt("keep");
        QueryRepository qr = new QueryRepository(domain, testDate, cwd, sessionParams);
        try {
            qr.queryRepository(new BufferedReader(new FileReader(icnListFile)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    class icnStuff {
        private String icn;
        Hashtable<String, Integer> templateCnt = new Hashtable();

        public icnStuff(String icn) {
            this.icn = icn;
        }

        public String getIcn() {
            return this.icn;
        }

        public int getCount(String type) {
            return this.templateCnt.get(type);
        }

        public Iterator iterator() {
            return this.templateCnt.entrySet().iterator();
        }

        public void setCount(String type, int count) {
            this.templateCnt.put(type, new Integer(count));
        }

        public int size() {
            return this.templateCnt.size();
        }
    }
}

