/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanRegistrar {
    private static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public static void registerMBean(ObjectName objName, Object mbean) {
        if (!mbeanServer.isRegistered(objName)) {
            try {
                mbeanServer.registerMBean(mbean, objName);
            }
            catch (Exception e) {
                IMSException.getIMSException("Error registering MBean.", e);
            }
        }
    }

    public static void registerMBean(String type, Object mbean) {
        MBeanRegistrar.registerMBean(type, mbean, null);
    }

    public static ObjectName registerMBean(String type, Object mbean, String[][] attributes) {
        ObjectName objectName = null;
        try {
            objectName = MBeanRegistrar.createObjectName(type, mbean, attributes);
            MBeanRegistrar.registerMBean(objectName, mbean);
        }
        catch (Exception e) {
            IMSException.getIMSException("Error registering MBean.", e);
        }
        return objectName;
    }

    public static void unregisterMBean(String type, Object mbean) {
        MBeanRegistrar.unregisterMBean(type, mbean, null);
    }

    public static void unregisterMBean(String type, Object mbean, String[][] attributes) {
        try {
            MBeanRegistrar.unregisterMBean(MBeanRegistrar.createObjectName(type, mbean, attributes));
        }
        catch (Exception e) {
            IMSException.getIMSException("Error unregistering mbean.", e);
        }
    }

    public static void unregisterMBean(ObjectName objectName) {
        try {
            if (mbeanServer.isRegistered(objectName)) {
                mbeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            IMSException.getIMSException("Error unregistering mbean.", e);
        }
    }

    public static void addNotificationListener(String name, Object mbean, NotificationListener listener) {
        MBeanRegistrar.addNotificationListener(name, mbean, listener, null);
    }

    public static void addNotificationListener(String name, Object mbean, NotificationListener listener, NotificationFilter filter) {
        try {
            ObjectName objectName = MBeanRegistrar.createObjectName(name, mbean);
            mbeanServer.addNotificationListener(objectName, listener, filter, mbean);
        }
        catch (Exception e) {
            IMSException.getIMSException("Error adding notification listener.", e);
            e.printStackTrace();
        }
    }

    public static ObjectName createObjectName(String type, Object mbean) throws MalformedObjectNameException {
        return MBeanRegistrar.createObjectName(type, mbean, null);
    }

    public static ObjectName createObjectName(String type, Object mbean, String[][] attributes) throws MalformedObjectNameException {
        int dotIndex = -1;
        Class<?> mbeanClass = mbean.getClass();
        String cls = mbeanClass.getSimpleName();
        Package pkg = mbeanClass.getPackage();
        StringBuffer sbObjectName = new StringBuffer(null != pkg ? pkg.getName() : "default").append(":type=").append(null != type ? type : cls);
        if (null != attributes) {
            for (int i = 0; i < attributes.length; ++i) {
                sbObjectName.append(",").append(attributes[i][0]).append("=").append(attributes[i][1]);
            }
        }
        ObjectName objectName = new ObjectName(sbObjectName.toString());
        return objectName;
    }
}

