/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.va.med.hds.hdr.common.util.FrameworkControlException;
import gov.va.med.hds.hdr.common.util.FrameworkProcessControl;
import gov.va.med.hds.hdr.common.util.GetArgs;
import java.io.File;
import java.util.ArrayList;

public class LogHandlerControl
extends FrameworkProcessControl {
    public LogHandlerControl(boolean start, boolean debug) {
        super((String)null);
        String cp = "config:lib/common.jar:lib/fhie.jar:lib/mail.jar:lib/activation.jar:lib/jvmi2.jarlib/xmlparserv2.jar:lib/tools.jar:lib/log4j-1.2.jar:lib/jaas.jar:lib/aqapi13.jar:lib/ojdbc14.jar:lib/loghandlers.jar:lib/externalutils.jar:lib/java-getopt-1.0.9.jar";
        this.cmdCol = new ArrayList();
        this.cmdCol.clear();
        this.cmdCol.add(this.javaHome + "/bin/java");
        this.cmdCol.add("-server");
        this.cmdCol.add("-Xbootclasspath/p:" + this.ORBlibs);
        if (start) {
            this.cmdCol.add("-Dims.module=MessageHandlerApp");
            this.cmdCol.add("-jar");
            this.cmdCol.add(this.cwd + "/lib/loghandlers.jar");
            this.cmdCol.add("-properties");
            this.cmdCol.add("fhie_properties.xml");
            this.cmdCol.add("-out");
            this.cmdCol.add("MessageHandlerApp.out");
            this.cmdCol.add("-err");
            this.cmdCol.add("MessageHandlerApp.err");
        } else {
            this.cmdCol.add("-classpath");
            this.cmdCol.add(cp);
            this.cmdCol.add("gov.fhie.common.util.JmsClient");
            this.cmdCol.add("IMS_LOG_PERF_Q");
            this.cmdCol.add("SHUTDOWN");
        }
        this.init(debug);
    }

    public void shutdownProcess(String pid) throws Exception {
        Process shutdownProc = null;
        try {
            System.out.println("\tMessageHandlerApp attempting graceful shutdown...");
            File dir = new File(this.getInitialDir());
            shutdownProc = Runtime.getRuntime().exec(this.cmdCol.toArray(new String[this.cmdCol.size()]), null, dir);
            shutdownProc.waitFor();
            if (!this.monitorProcess(pid, 15)) {
                throw new FrameworkControlException("Graceful shutdown failed.");
            }
        }
        catch (Exception e) {
            System.out.println("\tMessageHandlerApp: " + e.getLocalizedMessage() + "\n\tKilling MessageHandlerApp process (" + pid + ").");
            super.shutdownProcess(pid);
        }
    }

    public void run() {
        try {
            this.startProcess();
            while (null != this.getProcessObject() && !this.isStarted()) {
                LogHandlerControl.yield();
                LogHandlerControl.sleep(2000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSymbolicName() {
        return "MessageHandlerApp";
    }

    public static void main(String[] args) {
        GetArgs getOpts;
        boolean start = true;
        start = getOpts.getUnaryOpt("start", !(getOpts = new GetArgs(LogHandlerControl.class, args, "pid", "start:shutdown:debug")).getUnaryOpt("shutdown"));
        LogHandlerControl logHandler = new LogHandlerControl(start, getOpts.getUnaryOpt("debug"));
        if (start) {
            logHandler.start();
            while (logHandler.isAlive()) {
                LogHandlerControl.yield();
                try {
                    LogHandlerControl.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Process proc = logHandler.getProcessObject();
            if (null == proc) {
                System.out.println("MessageHandlerApp failed to start.");
                System.exit(1);
            } else {
                System.out.println("MessageHandlerApp has been started.");
            }
        } else {
            try {
                logHandler.shutdownProcess(getOpts.getArg("pid"));
            }
            catch (Exception e) {
                System.err.println("MessageHandlerApp shutdown failure:");
                e.printStackTrace();
            }
        }
    }
}

