/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.common.util.RegularExpressionHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;

public class HL7MessageMetaData
implements MessageMetaData {
    private final String SEG_TERM = new String(new byte[]{13});
    private String[] hl7;
    private String clinical_id;
    private String facilityId;
    private String nationalId;
    private String localId;
    private String pidDomain;
    private String messageControlId;
    private String messageDateTime;
    private String messageType;
    private String sendingApp;
    private String version;
    private String msh;
    private String pid;
    private HL7MessageInfo msgInfo;
    private final String fieldSep;
    private final String repSep;
    private final String cmpntSep;
    private final String subCmpntSep;

    public HL7MessageMetaData(String hl7, String clinical_id) {
        this.hl7 = hl7.split(this.SEG_TERM, 3);
        this.msh = this.getValue(this.hl7, 0);
        this.pid = this.getValue(this.hl7, 1);
        this.msgInfo = new HL7MessageInfoImpl(hl7);
        this.fieldSep = RegularExpressionHelper.escape(this.msgInfo.getFieldDelimeter());
        this.repSep = RegularExpressionHelper.escape(this.msgInfo.getRepetitionSeparator());
        this.cmpntSep = RegularExpressionHelper.escape(this.msgInfo.getComponentSeparator());
        this.subCmpntSep = RegularExpressionHelper.escape(this.msgInfo.getSubcomponentSeparator());
        this.clinical_id = clinical_id;
    }

    public String getClinicalId() {
        return this.clinical_id;
    }

    public String getClinicallyRelevantDate() {
        return null;
    }

    public String getFacilityId() {
        if (null == this.facilityId) {
            String[] flds = this.msh.split(this.fieldSep, 4);
            this.facilityId = this.getValue(this.getValue(flds, 3).split(this.cmpntSep), 0);
        }
        return this.facilityId;
    }

    public String getLocalId() {
        if (null == this.localId) {
            String[] flds = this.pid.split(this.fieldSep);
            String[] ids = this.getValue(flds, 3).split(this.repSep);
            int arrLen = ids.length;
            for (int i = 0; i < arrLen; ++i) {
                String[] cmpnts = ids[i].split(this.cmpntSep);
                if (!this.getValue(cmpnts, 4).equals("PI")) continue;
                this.localId = this.getValue(cmpnts, 0);
                break;
            }
        }
        return this.localId;
    }

    public String getNationalId() {
        if (null == this.nationalId) {
            String[] flds = this.pid.split(this.fieldSep);
            String[] ids = this.getValue(flds, 3).split(this.repSep);
            int arrLen = ids.length;
            for (int i = 0; i < arrLen; ++i) {
                String[] cmpnts = ids[i].split(this.cmpntSep);
                if (!this.getValue(cmpnts, 4).equals("NI")) continue;
                this.nationalId = this.getValue(cmpnts, 0);
                break;
            }
        }
        return this.nationalId;
    }

    public String getMessageControlId() {
        if (null == this.messageControlId) {
            this.messageControlId = this.getValue(this.msh.split(this.fieldSep), 9);
        }
        return this.messageControlId;
    }

    public String getMessageDateTime() {
        if (null == this.messageDateTime) {
            this.messageDateTime = this.getValue(this.msh.split(this.fieldSep), 6);
            this.messageDateTime = 0 < this.messageDateTime.length() && DateTimeUtility.validateISOTime(this.messageDateTime) ? DateTimeUtility.normalizeDateString(this.messageDateTime, this.getFacilityId()) : this.messageDateTime;
        }
        return this.messageDateTime;
    }

    public String getMessageType() {
        if (null == this.messageType) {
            String[] flds = this.msh.split(this.fieldSep);
            String[] type = this.getValue(flds, 8).split(this.cmpntSep);
            this.messageType = new StringBuffer(this.getValue(flds, 2)).append("_").append(this.getValue(type, 0)).append("_").append(this.getValue(type, 1)).toString();
        }
        return this.messageType;
    }

    public String getPidDomain() {
        if (null == this.pidDomain) {
            String[] flds = this.pid.split(this.fieldSep);
            String[] ids = this.getValue(flds, 3).split(this.repSep);
            int arrLen = ids.length;
            for (int i = 0; i < arrLen; ++i) {
                String[] fields = this.getValue(ids, i).split(this.cmpntSep);
                if (!this.getValue(fields, 4).equals("PI")) continue;
                this.pidDomain = new StringBuffer("MED.VA.GOV/").append(this.getValue(this.getValue(fields, 5).split(this.subCmpntSep), 1)).toString();
                break;
            }
        }
        return this.pidDomain;
    }

    public String getSendingApplication() {
        if (null == this.sendingApp) {
            this.sendingApp = this.getValue(this.msh.split(this.fieldSep), 2);
        }
        return this.sendingApp;
    }

    public String getVersion() {
        if (null == this.version) {
            this.version = this.msgInfo.getVersion();
        }
        return this.version;
    }

    private String getValue(String[] arr, int position) {
        return null != arr && arr.length > position ? arr[position] : "";
    }
}

