/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.apache.commons.pool.impl.StackObjectPoolFactory;

public final class HL7Checksum
implements PoolableObjectFactory {
    private static final String SEG_TERM = new String(new byte[]{13});
    private static StackObjectPool mdPool;
    private static final char[] hex;

    public void activateObject(Object arg0) {
        if (null != arg0 && arg0 instanceof MessageDigest) {
            ((MessageDigest)arg0).reset();
        }
    }

    public void destroyObject(Object arg0) throws Exception {
    }

    public Object makeObject() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-1");
    }

    public void passivateObject(Object arg0) throws Exception {
    }

    public boolean validateObject(Object arg0) {
        if (null != arg0 && arg0 instanceof MessageDigest) {
            MessageDigest md = (MessageDigest)arg0;
            md.reset();
            return md.getAlgorithm().equals("SHA-1");
        }
        return false;
    }

    private HL7Checksum() {
    }

    private static MessageDigest getMessageDigest() throws Exception {
        MessageDigest md = (MessageDigest)mdPool.borrowObject();
        return md;
    }

    private static void closeMessageDigest(MessageDigest md) throws Exception {
        md.reset();
        mdPool.returnObject((Object)md);
    }

    public static String checkSum(String msg) throws NoSuchAlgorithmException {
        String digest = null;
        try {
            MessageDigest md = HL7Checksum.getMessageDigest();
            digest = HL7Checksum.toString(md.digest(msg.getBytes()));
            HL7Checksum.closeMessageDigest(md);
        }
        catch (Exception e) {
            if (e instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)e;
            }
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return digest;
    }

    public static byte[] checkSum(byte[] msg) throws NoSuchAlgorithmException {
        byte[] digest = null;
        try {
            MessageDigest md = HL7Checksum.getMessageDigest();
            digest = md.digest(msg);
            HL7Checksum.closeMessageDigest(md);
        }
        catch (Exception e) {
            if (e instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)e;
            }
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return digest;
    }

    public static byte[] checkSumHL7(String hl7Msg, MessageMetaData metaData) throws NoSuchAlgorithmException {
        String[] segs = hl7Msg.split(SEG_TERM, 3);
        if (3 > segs.length) {
            return null;
        }
        String msg = new StringBuffer(segs[2].length() + 40).append(metaData.getClinicalId()).append(metaData.getLocalId()).append(metaData.getPidDomain()).append(metaData.getMessageType()).append(segs[2]).toString();
        byte[] digest = null;
        try {
            MessageDigest md = HL7Checksum.getMessageDigest();
            digest = md.digest(msg.getBytes());
            HL7Checksum.closeMessageDigest(md);
        }
        catch (Exception e) {
            if (e instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)e;
            }
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return digest;
    }

    public static boolean matches(String md1, String md2) {
        return md1.equals(md2);
    }

    public static boolean matches(byte[] md1, byte[] md2) {
        return MessageDigest.isEqual(md1, md2);
    }

    public static String toString(byte[] bytes) {
        char[] chrs = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            chrs[j] = hex[(bytes[i] & 0xF0) >>> 4];
            chrs[j + 1] = hex[bytes[i] & 0xF];
            j += 2;
        }
        return new String(chrs);
    }

    public static void main(String[] args) throws Exception {
        String m1 = null;
        try {
            FileInputStream f1 = new FileInputStream(args[0]);
            byte[] b1 = new byte[f1.available()];
            f1.read(b1);
            if (null != b1 && 0 < b1.length) {
                m1 = new String(b1);
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        StringBuffer mx = new StringBuffer();
        String[] segs = m1.split(SEG_TERM);
        for (int i = 0; i < segs.length; ++i) {
            char[] chrs = segs[i].toCharArray();
            if (3 > chrs.length) continue;
            if (chrs[0] >= 'A' && chrs[0] <= 'Z') {
                mx.append(chrs);
            } else {
                mx.append(chrs, 1, chrs.length - 1);
            }
            mx.append(SEG_TERM);
        }
        final String m2 = mx.toString();
        if (null != m2 && 0 < m1.length()) {
            for (int i = 100; i > 0; --i) {
                Thread t = new Thread("HL7Checksum-" + i + " "){

                    public void run() {
                        try {
                            for (int j = 1000; j > 0; --j) {
                                String string = HL7Checksum.toString(HL7Checksum.checkSumHL7(m2, new MessageMetaData(){

                                    public String getMessageType() {
                                        return "HDRPRES_RDE_O11";
                                    }

                                    public String getVersion() {
                                        return "2.4";
                                    }

                                    public String getClinicalId() {
                                        return "82550-657_52_39.3-611002-657_52_.001";
                                    }

                                    public String getSendingApplication() {
                                        return "HDRPRES";
                                    }

                                    public String getMessageDateTime() {
                                        return "20050113155726-0700";
                                    }

                                    public String getClinicallyRelevantDate() {
                                        return "9/2/2005 6:00:00. AM";
                                    }

                                    public String getPidDomain() {
                                        return "MED.VA.GOV/657";
                                    }

                                    public String getFacilityId() {
                                        return "STLS3.FO-SMOKETESTURL        ";
                                    }

                                    public String getLocalId() {
                                        return "266510";
                                    }

                                    public String getMessageControlId() {
                                        return "7594682";
                                    }
                                }));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.out.println(this.getName() + ": mdPool.size: " + (mdPool.getNumActive() + mdPool.getNumIdle()));
                    }
                };
                t.start();
            }
        }
    }

    static {
        StackObjectPoolFactory poolFactory = new StackObjectPoolFactory((PoolableObjectFactory)new HL7Checksum(), 100, 50);
        mdPool = (StackObjectPool)poolFactory.createPool();
        try {
            for (int i = 0; i < 50; ++i) {
                mdPool.addObject();
            }
        }
        catch (Exception e) {
            IMSException.getIMSException(e);
        }
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

