/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetArgs {
    public static final boolean UNARY_ONLY = true;
    public static final boolean BINARY_ONLY = false;
    private String mainClass;
    private Properties pairs = new Properties();
    private String[] binaryOpts = new String[0];
    private ArrayList<String[]> exclusiveBinaryOpts = new ArrayList();
    private String[] unaryOpts = new String[0];
    private ArrayList<String[]> exclusiveUnaryOpts = new ArrayList();
    private String[] requiredOpts = new String[0];
    private final Pattern defaultOptsPattern = Pattern.compile("\\[(.+)=(.+)\\]");

    public GetArgs(Class parent, String[] args, String binary, String unary) {
        this.init(parent, args, binary, unary, null);
    }

    public GetArgs(Class parent, String[] args, String argNames, boolean unary) {
        this.init(parent, args, unary ? null : argNames, unary ? argNames : null, null);
    }

    public GetArgs(Class parent, String[] args, String binary, String unary, String required) {
        this.init(parent, args, binary, unary, required);
    }

    public GetArgs(Class parent, String[] args, String argNames, String required, boolean unary) {
        this.init(parent, args, unary ? null : argNames, unary ? argNames : null, required);
    }

    private void init(Class parent, String[] args, String binaryOpts, String unaryOpts, String requiredOpts) {
        boolean hasRequired = null != requiredOpts && 0 != requiredOpts.length();
        this.mainClass = parent.getName();
        if (null != unaryOpts && 0 != unaryOpts.length()) {
            this.unaryOpts = this.exclusiveOpts(unaryOpts.split(":"), true);
        }
        if (null != binaryOpts && 0 != binaryOpts.length()) {
            this.binaryOpts = this.exclusiveOpts(binaryOpts.split(":"), false);
        }
        if (hasRequired) {
            this.requiredOpts = requiredOpts.split(":");
            this.addDefaults(this.requiredOpts);
        }
        for (int i = 0; i < args.length; ++i) {
            boolean unary = false;
            String opt = args[i].substring(1);
            unary = this.isUnaryOpt(opt);
            if (!(unary || this.isBinaryOpt(opt) || parent.getName().equals(args[i]))) {
                this.unknownOpt(args[i], parent);
                continue;
            }
            this.pairs.put(opt, unary ? "true" : args[++i]);
        }
        if (hasRequired && this.missingRequired() || this.checkExclusive()) {
            this.showUsage(parent);
        }
    }

    private void addDefaults(String[] opts) {
        Matcher match = null;
        for (int i = 0; i < opts.length; ++i) {
            match = this.defaultOptsPattern.matcher(opts[i]);
            if (!match.matches()) continue;
            opts[i] = match.group(1);
            String value = match.group(2);
            this.pairs.put(opts[i], value);
        }
    }

    private boolean checkExclusive() {
        int i;
        String[] opts;
        int excluded;
        Iterator<String[]> iter = this.exclusiveUnaryOpts.iterator();
        while (iter.hasNext()) {
            excluded = 0;
            opts = iter.next();
            for (i = 0; i < opts.length; ++i) {
                excluded += this.pairs.containsKey(opts[i]) ? 1 : 0;
            }
            if (true == excluded) continue;
            return true;
        }
        iter = this.exclusiveBinaryOpts.iterator();
        while (iter.hasNext()) {
            excluded = 0;
            opts = iter.next();
            for (i = 0; i < opts.length; ++i) {
                excluded += this.pairs.containsKey(opts[i]) ? 1 : 0;
            }
            if (1 == excluded) continue;
            return true;
        }
        return false;
    }

    private String[] exclusiveOpts(String[] opts, boolean unary) {
        boolean exclusiveGroup = false;
        List<String> optsL = Arrays.asList(opts);
        ArrayList<String> exclusives = new ArrayList<String>();
        Iterator<String> iter = optsL.iterator();
        while (iter.hasNext()) {
            String opt;
            String optRef = opt = iter.next();
            if (opt.startsWith("(")) {
                exclusiveGroup = true;
                opt = opt.substring(1);
            } else if (exclusiveGroup && opt.endsWith(")")) {
                exclusiveGroup = false;
                opt = opt.substring(0, opt.length() - 1);
                exclusives.add(opt);
            }
            if (exclusiveGroup) {
                exclusives.add(opt);
            }
            optsL.set(optsL.indexOf(optRef), opt);
        }
        if (0 != exclusives.size()) {
            if (unary) {
                this.exclusiveUnaryOpts.add(exclusives.toArray(new String[exclusives.size()]));
            } else {
                this.exclusiveBinaryOpts.add(exclusives.toArray(new String[exclusives.size()]));
            }
        }
        return optsL.toArray(opts);
    }

    private boolean missingRequired() {
        for (int i = 0; i < this.requiredOpts.length; ++i) {
            if (this.hasOpt(this.requiredOpts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isRequired(String arg) {
        for (int i = 0; i < this.requiredOpts.length; ++i) {
            if (!arg.equals(this.requiredOpts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUnaryOpt(String arg) {
        for (int i = 0; i < this.unaryOpts.length; ++i) {
            if (!arg.equals(this.unaryOpts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isBinaryOpt(String arg) {
        for (int i = 0; i < this.binaryOpts.length; ++i) {
            if (!arg.equals(this.binaryOpts[i])) continue;
            return true;
        }
        return false;
    }

    public int getIntArg(String arg) {
        String value = (String)this.pairs.get(arg);
        if (null == value) {
            value = "0";
        }
        return Integer.parseInt(value);
    }

    public String getArg(String arg) {
        return (String)this.pairs.get(arg);
    }

    public boolean getUnaryOpt(String arg) {
        return this.pairs.containsKey(arg);
    }

    public int getIntArg(String arg, int defaultValue) {
        return this.pairs.containsKey(arg) ? Integer.parseInt((String)this.pairs.get(arg)) : defaultValue;
    }

    public String getArg(String arg, String defaultValue) {
        return this.pairs.containsKey(arg) ? (String)this.pairs.get(arg) : defaultValue;
    }

    public boolean getUnaryOpt(String arg, boolean defaultValue) {
        return this.pairs.containsKey(arg) ? true : defaultValue;
    }

    public boolean hasOpt(String arg) {
        String[] opts;
        for (String opt : opts = arg.split(":")) {
            if (!this.pairs.containsKey(opt.trim())) continue;
            return true;
        }
        return false;
    }

    public void usage(int exitValue) {
        this.usage();
        System.exit(exitValue);
    }

    private void showUsage(Class parent) {
        Method usageMethod = null;
        try {
            usageMethod = parent.getDeclaredMethod("usage", Integer.TYPE);
            usageMethod.invoke(null, new Integer(1));
        }
        catch (Exception e) {
            try {
                usageMethod = parent.getDeclaredMethod("usage", new Class[0]);
                usageMethod.invoke(null, (Object[])null);
            }
            catch (Exception e1) {
                Method[] methods = parent.getDeclaredMethods();
                this.usage(1);
            }
        }
    }

    public void usage() {
        int i;
        StringBuffer usageStr = new StringBuffer("java ");
        usageStr.append(this.mainClass);
        boolean optional = true;
        for (i = 0; i < this.unaryOpts.length; ++i) {
            optional = !this.isRequired(this.unaryOpts[i]);
            usageStr.append((optional ? " [-" : " -") + this.unaryOpts[i] + (optional ? "]" : ""));
        }
        for (i = 0; i < this.binaryOpts.length; ++i) {
            optional = !this.isRequired(this.binaryOpts[i]);
            usageStr.append((optional ? " [-" : " -") + this.binaryOpts[i] + " " + this.binaryOpts[i] + ".value" + (optional ? "]" : ""));
        }
        System.err.println(usageStr.toString() + "\n");
    }

    public void unknownOpt(String opt, Class parent) {
        if ("-?".equals(opt) || "-help".equals(opt)) {
            this.showUsage(parent);
        }
        System.err.println("Ignoring unknown option '" + opt + "' for " + this.mainClass + ". Continuing...");
    }
}

