/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.va.med.hds.hdr.common.util.FrameworkControlException;
import gov.va.med.hds.hdr.common.util.FrameworkOutputStream;
import gov.va.med.hds.hdr.common.util.FrameworkSyncListener;
import gov.va.med.hds.hdr.common.util.IProcessControl;
import gov.va.med.hds.hdr.common.util.StdIOListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

public abstract class FrameworkProcessControl
extends Thread
implements IProcessControl {
    private FrameworkOutputStream out;
    private FrameworkOutputStream err;
    private String[] cmd;
    protected Collection<String> cmdCol;
    private Process proc;
    protected String cwd = System.getProperty("user.dir");
    protected final String javaHome = System.getProperty("java.home");
    protected final String javaClassPath = System.getProperty("java.class.path");
    protected char pathSeparator = System.getProperty("path.separator").charAt(0);
    protected final String ORBlibs = "cots/Orbacus-4.1.2/lib/OB.jar" + this.pathSeparator + "cots/Orbacus-4.1.2/lib/OBNaming.jar";
    protected final String commonLibs = this.pathSeparator + "lib/commons-collections-3.1.jar" + this.pathSeparator + "lib/commons-dbcp-1.2.1.jar" + this.pathSeparator + "lib/commons-pool-1.2.jar";
    private final String[] debugArgs = new String[]{"-Xrunjdwp:transport=dt_socket,server=y,address=[port],suspend=y", "-Xdebug", "-Xnoagent"};
    private static int lastPort = 8000;
    protected int[] state = new int[]{0};
    private static final String space = " ";
    private static final String newline = System.getProperty("line.separator");
    protected static final int TYPE_STDOUT = 0;
    protected static final int TYPE_STDERR = 1;

    private FrameworkProcessControl() {
    }

    public FrameworkProcessControl(boolean start, boolean debug) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FrameworkProcessControl(String sync) {
        if (null != sync) {
            Closeable closeable = System.in;
            synchronized (closeable) {
                if (System.out instanceof FrameworkOutputStream) {
                    this.out = (FrameworkOutputStream)System.out;
                } else {
                    this.out = new FrameworkOutputStream(System.out);
                    System.setOut(this.out);
                }
                if (System.err instanceof FrameworkOutputStream) {
                    this.err = (FrameworkOutputStream)System.err;
                } else {
                    this.err = new FrameworkOutputStream(System.err);
                    System.setErr(this.err);
                }
            }
            closeable = this.out;
            synchronized (closeable) {
                this.out.addListener(new FrameworkSyncListener(this.state, sync));
            }
        }
    }

    protected void init(boolean debug) {
        int i;
        if (debug) {
            ((ArrayList)this.cmdCol).add(1, this.debugArgs[0].replaceFirst("\\[port\\]", String.valueOf(lastPort += 10)));
            for (i = 1; i < this.debugArgs.length; ++i) {
                ((ArrayList)this.cmdCol).add(i + 1, this.debugArgs[i]);
            }
        }
        this.cmd = this.cmdCol.toArray(new String[this.cmdCol.size()]);
        for (i = 0; i < this.cmd.length; ++i) {
            if (-1 == this.cmd[i].indexOf("-classpath")) continue;
            this.cmd[++i] = this.cmd[i].replace(':', this.pathSeparator) + this.commonLibs;
            int n = i;
            this.cmd[n] = this.cmd[n] + this.pathSeparator + this.javaClassPath;
            break;
        }
    }

    public abstract String getSymbolicName();

    public String getStartProcess() {
        StringBuffer start = new StringBuffer(newline);
        String sp = "";
        for (int i = 0; i < this.cmd.length; ++i) {
            start.append(sp + this.cmd[i]);
            sp = space;
        }
        start.append(newline);
        return start.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean monitorProcess(String pid, int timeout) throws Exception {
        Process proc = null;
        boolean stopped = false;
        int tries = 3;
        try {
            while (!stopped && 0 < tries) {
                try {
                    proc = Runtime.getRuntime().exec("ps -p " + pid);
                    if (0 == proc.exitValue()) {
                        throw new Exception("Successful.");
                    }
                    stopped = true;
                }
                catch (Exception e) {
                    --tries;
                    try {
                        Thread.sleep(timeout * 1000);
                    }
                    catch (InterruptedException ie) {
                        System.out.println(ie.getLocalizedMessage());
                    }
                }
            }
            return stopped;
        }
        finally {
            if (null != proc && 0 < proc.exitValue()) {
                stopped = true;
            }
            proc.destroy();
            proc = null;
        }
    }

    public void shutdownProcess(String pid) throws Exception {
        this.proc = Runtime.getRuntime().exec("kill -9 " + pid);
        this.proc.waitFor();
    }

    protected Process startProcess() throws Exception {
        String procName = this.getClass().getName();
        try {
            this.proc = Runtime.getRuntime().exec(this.cmd, null, new File(this.cwd));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.proc.destroy();
            this.proc = null;
            throw new Exception(e.getMessage(), e);
        }
        this.state[0] = 1;
        StdIOListener stdIOListener = new StdIOListener(this.proc);
        try {
            this.openPipe(this.proc, procName + ".Err", 1, stdIOListener);
            int val = this.proc.exitValue();
            this.proc = null;
            throw new Exception(procName + " failed to start: exit value=" + val);
        }
        catch (IllegalThreadStateException is) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            this.openPipe(this.proc, procName + ".Out", 0, stdIOListener);
            return this.proc;
        }
    }

    public boolean isStarted() {
        return 2 <= this.getFrameworkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrameworkState() {
        int[] nArray = this.state;
        synchronized (this.state) {
            if (this.state[0] == 2 || this.state[0] == 1) {
                try {
                    if (null != this.proc) {
                        this.proc.exitValue();
                    }
                    this.proc = null;
                    this.state[0] = 0;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setState(int newState) {
        int lastState = this.getFrameworkState();
        if (newState < 0 || newState > 3) return lastState;
        int[] nArray = this.state;
        synchronized (this.state) {
            this.state[0] = newState;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return lastState;
        }
    }

    public void kill() {
        if (null != this.proc) {
            this.proc.destroy();
        }
    }

    protected void openPipe(final Process proc, String threadName, final int type, final StdIOListener stdIOListener) {
        Thread pipeThread = new Thread(threadName){

            private int readIO(InputStream pipe) {
                int chr = -1;
                try {
                    StringBuffer str = new StringBuffer();
                    int cnt = chr = pipe.available();
                    while (0 < cnt--) {
                        chr = pipe.read();
                        if (-1 == chr) continue;
                        str.append((char)chr);
                    }
                    stdIOListener.stdIOEvent(type, str.toString());
                }
                catch (IOException e) {
                    try {
                        pipe.close();
                    }
                    catch (IOException e1) {}
                }
                catch (FrameworkControlException e) {
                    e.printStackTrace();
                    try {
                        pipe.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                return chr;
            }

            public void run() {
                Process associatedProc = proc;
                StdIOListener listener = stdIOListener;
                InputStream pipe = 0 == type ? proc.getInputStream() : (1 == type ? proc.getErrorStream() : null);
                int chr = 0;
                while (true) {
                    if (FrameworkProcessControl.this.isStarted()) {
                        return;
                    }
                    try {
                        proc.exitValue();
                        this.readIO(pipe);
                        try {
                            pipe.close();
                        }
                        catch (IOException e1) {}
                    }
                    catch (IllegalThreadStateException e2) {
                        chr = this.readIO(pipe);
                        1.yield();
                        try {
                            1.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            // empty catch block
                        }
                        if (-1 != chr) continue;
                    }
                    break;
                }
                proc.destroy();
            }
        };
        pipeThread.setDaemon(true);
        pipeThread.start();
    }

    public Process getProcessObject() {
        return this.proc;
    }

    public void setInitialDir(String cwd) {
        this.cwd = cwd;
    }

    public String getInitialDir() {
        return this.cwd;
    }

    protected void finalize() throws Throwable {
        if (null != this.out) {
            this.out.flush();
            this.out.close();
        }
        if (null != this.err) {
            this.err.flush();
            this.err.close();
        }
        super.finalize();
    }

    public String toString() {
        return this.getSymbolicName();
    }
}

