/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExceptionList
extends Exception {
    private List<Throwable> causes = new ArrayList<Throwable>();
    private int current = 0;

    public void addCause(Throwable cause) {
        this.resetCurrentCause();
        this.causes.add(cause);
    }

    public int getExceptionCount() {
        return this.causes.size();
    }

    public void resetCurrentCause() {
        this.current = 0;
    }

    public List getCauses() {
        return this.causes;
    }

    public Throwable getCause() {
        if (this.current >= this.causes.size()) {
            return null;
        }
        return this.causes.get(this.current);
    }

    public String getMessage() {
        StringBuffer sbMessage = new StringBuffer("There ");
        int exceptionCount = this.getExceptionCount();
        if (exceptionCount <= 1) {
            sbMessage.append("was ");
        } else if (exceptionCount > 1) {
            sbMessage.append("were ");
        }
        sbMessage.append(exceptionCount).append(" exception that were thrown as a result of the operation.\n").append("Exception Details:\n");
        for (int i = 0; i < this.causes.size(); ++i) {
            sbMessage.append("\n\tException " + i).append("\t").append(this.causes.get(i).getMessage()).append("\n");
        }
        return sbMessage.toString();
    }

    public StackTraceElement[] getStackTrace() {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        for (int i = 0; i < this.causes.size(); ++i) {
            list.addAll(Arrays.asList(this.causes.get(i).getStackTrace()));
        }
        return list.toArray(new StackTraceElement[0]);
    }

    public void printStackTrace() {
        for (int i = 0; i < this.causes.size(); ++i) {
            System.err.println("Exception " + i + " stacktrace...");
            this.causes.get(i).printStackTrace();
            System.err.println();
        }
    }

    public void printStackTrace(PrintStream ps) {
        for (int i = 0; i < this.causes.size(); ++i) {
            ps.println("Exception " + i + " stacktrace...");
            this.causes.get(i).printStackTrace(ps);
            ps.println();
        }
    }

    public void printStackTrace(PrintWriter pw) {
        for (int i = 0; i < this.causes.size(); ++i) {
            pw.println("Exception " + i + " stacktrace...");
            this.causes.get(i).printStackTrace(pw);
            pw.println();
        }
    }
}

