/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.util;

import gov.fhie.transformer.systemcontrol.SupportComponents;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.util.HL7Checksum;
import gov.va.med.hds.hdr.common.util.SqlUtil;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;

public class ChecksumRepository {
    private Connection select_rep;
    private Connection update_rep;
    private Statement stmt;
    private PreparedStatement updt;
    private BufferedWriter bw;
    private long start;
    private String schemaHL7_PLUS;
    private static final String readRepTemplate = "select /*+ parallel (hl7_repository 8) */  local_pid,pid_domain,message_ty,clinical_id,message from {0}hl7_repository where checksum is null and rownum<10001";
    private final String readRep;
    private static final String updateTemplate = "update {0}hl7_repository set checksum=? where local_pid=? and pid_domain=? and message_ty=? and clinical_id=?";
    private final String update;

    public ChecksumRepository(String datasource) throws SQLException, IOException {
        this.select_rep = DataSourceManager.getInstance().getDataSource(datasource).getConnection();
        this.update_rep = DataSourceManager.getInstance().getDataSource(datasource).getConnection();
        this.update_rep.setAutoCommit(false);
        String schema = SqlUtil.getSchemaFor("hl7_plus", ".");
        this.schemaHL7_PLUS = 0 < schema.length() ? "hl7_plus." : schema;
        this.readRep = MessageFormat.format(readRepTemplate, this.schemaHL7_PLUS);
        this.update = MessageFormat.format(updateTemplate, this.schemaHL7_PLUS);
        this.updt = this.update_rep.prepareStatement(this.update);
        this.stmt = this.select_rep.createStatement();
        this.bw = new BufferedWriter(new FileWriter("checksum.duplicates"));
    }

    public ResultSet query() throws SQLException {
        this.start = System.currentTimeMillis();
        boolean hasRows = false;
        ResultSet rs = this.stmt.executeQuery(this.readRep);
        hasRows = rs.next();
        if (hasRows) {
            return rs;
        }
        return null;
    }

    public void finish(boolean commit) throws SQLException {
        if (commit) {
            this.update_rep.commit();
            this.select_rep.commit();
        } else {
            this.update_rep.rollback();
            this.select_rep.rollback();
        }
        if (null != this.stmt) {
            this.stmt.close();
        }
        if (null != this.updt) {
            this.updt.close();
        }
        this.update_rep.close();
        this.select_rep.close();
    }

    public void updateChecksum(ResultSet rs) throws NoSuchAlgorithmException, SQLException, IOException {
        int count = 0;
        ArrayList mmds = new ArrayList();
        do {
            ResultSetMetaData mmd = new ResultSetMetaData();
            mmd.setResultSet(rs);
            this.updt.setString(1, HL7Checksum.toString(HL7Checksum.checkSumHL7(mmd.getMessage(), mmd)));
            this.updt.setString(2, mmd.getLocalId());
            this.updt.setString(3, mmd.getPidDomain());
            this.updt.setString(4, mmd.getMessageType());
            this.updt.setString(5, mmd.getClinicalId());
            try {
                this.updt.executeUpdate();
            }
            catch (SQLException e) {
                if (1 != e.getErrorCode()) {
                    throw e;
                }
                this.bw.write(mmd.getClinicalId() + ":\n\t" + mmd.getMessage() + "\n\n");
                --count;
            }
            ++count;
            mmd = null;
        } while (rs.next());
        rs.close();
        this.update_rep.commit();
        long stop = System.currentTimeMillis();
        System.out.println(count + " rows updated (" + (stop - this.start) + "ms).");
        if (0 == count) {
            System.out.println("There seem to be some duplicates here.  Check the file 'bin/checksum.duplicates'\nExiting the process...");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ChecksumRepository csr = null;
        ResultSet rs = null;
        long start = 0L;
        long stop = 0L;
        try {
            System.out.println("Initializing stuff...");
            SupportComponents sc = new SupportComponents();
            System.out.println("Starting to process: " + new Date().toString());
            csr = new ChecksumRepository(args[0]);
            start = System.currentTimeMillis();
            while (null != (rs = csr.query())) {
                csr.updateChecksum(rs);
            }
            csr.finish(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                csr.finish(false);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            stop = System.currentTimeMillis();
            System.out.println("Completed: " + new Date(stop).toString());
            System.out.println("Total time: " + (stop - start));
        }
    }

    private class ResultSetMetaData
    implements MessageMetaData {
        private StringBuffer msg = new StringBuffer();
        private String local_id;
        private String pid_domain;
        private String message_ty;
        private String clinical_id;
        private String checksum;

        public void setResultSet(ResultSet rs) throws SQLException, IOException {
            int len;
            this.msg.setLength(0);
            Clob clob = rs.getClob("message");
            Reader clobReader = clob.getCharacterStream();
            char[] chars = new char[2048];
            do {
                if (0 >= (len = clobReader.read(chars))) continue;
                this.msg.append(chars, 0, len);
            } while (2048 == len);
            try {
                this.local_id = rs.getString("local_pid");
                this.pid_domain = rs.getString("pid_domain");
                this.message_ty = rs.getString("message_ty");
                this.clinical_id = rs.getString("clinical_id");
                this.checksum = rs.getString("checksum");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        public String getChecksum() {
            return this.checksum;
        }

        public String getLocalId() {
            return this.local_id;
        }

        public String getPidDomain() {
            return this.pid_domain;
        }

        public String getSendingApplication() {
            return "";
        }

        public String getFacilityId() {
            return "";
        }

        public String getMessageDateTime() {
            return "";
        }

        public String getVersion() {
            return "";
        }

        public String getMessageControlId() {
            return "";
        }

        public String getMessageType() {
            return this.message_ty;
        }

        public String getClinicalId() {
            return this.clinical_id;
        }

        public String getClinicallyRelevantDate() {
            return "";
        }

        public String getMessage() {
            return this.msg.toString();
        }
    }
}

