/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.server;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.rpc.server.RPCServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;

public abstract class RequestHandler
extends Thread {
    protected Socket socket = null;
    protected Class brokerClass = null;
    protected Thread thisThread;

    public RequestHandler(Class brokerClass) {
        this.brokerClass = brokerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        while (true) {
            if (this.socket == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException except) {
                    return;
                }
            }
            try {
                this.thisThread = Thread.currentThread();
                this.handleRequest();
                continue;
            }
            catch (Exception e) {
                IMSException.getIMSException("An exception was thrown while handling request.", e);
                continue;
            }
            finally {
                try {
                    RPCServer.getHandlers().returnObject((Object)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest() throws Exception {
        if (this.socket != null) {
            InputStream is = null;
            PrintStream ps = null;
            try {
                is = this.socket.getInputStream();
                ps = new PrintStream(this.socket.getOutputStream());
                this.socket.setSoTimeout(RPCServer.getTimeoutMilliseconds());
                this.socket.setSoLinger(true, RPCServer.getLingerTimeSeconds());
                this.handleRequest(is, ps);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (ps != null) {
                    ps.flush();
                    ps.close();
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected abstract void handleRequest(InputStream var1, PrintStream var2) throws Exception;

    public synchronized void setSocket(Socket socket) {
        this.socket = socket;
        this.notify();
    }
}

