/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.server;

import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.rpc.server.PoolableRequestHandlerObjectFactory;
import gov.va.med.hds.hdr.common.rpc.server.RPCServerInitializationException;
import gov.va.med.hds.hdr.common.rpc.server.RequestHandler;
import gov.va.med.hds.hdr.common.rpc.server.RequestHandlerPool;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class RPCServer
extends Thread {
    private static final String ATTR_VALUE = "value";
    private static final String XP_RPC_LISTENING_PORT = "rpcserver/property[@key='listening-port']";
    private static final String XP_RPC_MAX_HANDLERS = "rpcserver/property[@key='max-handlers']";
    private static final String XP_RPC_TIMEOUT_MILLIS = "rpcserver/property[@key='timeout-milliseconds']";
    private static final String XP_RPC_LINGER_TIME_SECS = "rpcserver/property[@key='linger-time-seconds']";
    private static final String XP_REQUEST_HANDLER_CLASS = "rpcserver/property[@key='request-handler-class']";
    private static final String XP_REQUEST_BROKER_CLASS = "rpcserver/property[@key='request-broker-class']";
    private static int port = 5001;
    private static ObjectPool handlers = null;
    private static int maxHandlers = 5;
    private static int timeoutMilliseconds = 30000;
    private static int lingerTimeSeconds = 10;
    private static Class requestHandler = null;
    private static Class requestBroker = null;
    private PropertyMgr propertyMgr = null;

    public RPCServer(PropertyMgr propertyMgr) {
        this.propertyMgr = propertyMgr;
    }

    private void loadProperties() throws RPCServerInitializationException {
        String rhc;
        String p = this.propertyMgr.getProperty(XP_RPC_LISTENING_PORT).getAttribute(ATTR_VALUE);
        if (p != null && p.length() > 0) {
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException e) {
                throw new RPCServerInitializationException("The port value of the RPC server configuration must be a positive integer.", e);
            }
        } else {
            throw new RPCServerInitializationException("Port configuration parameter not specified in application configuration.");
        }
        String mh = this.propertyMgr.getProperty(XP_RPC_MAX_HANDLERS).getAttribute(ATTR_VALUE);
        if (mh != null && mh.length() > 0) {
            try {
                maxHandlers = Integer.parseInt(mh);
            }
            catch (NumberFormatException e) {
                throw new RPCServerInitializationException("The maximum handlers configuraiton paramter must be a positive integer.", e);
            }
        } else {
            throw new RPCServerInitializationException("Maximum handlers parameter not specified in application configuration.");
        }
        String tom = this.propertyMgr.getProperty(XP_RPC_TIMEOUT_MILLIS).getAttribute(ATTR_VALUE);
        if (tom != null && tom.length() > 0) {
            try {
                timeoutMilliseconds = Integer.parseInt(tom);
            }
            catch (NumberFormatException e) {
                throw new RPCServerInitializationException("The timeout milliseconds configuration paramter must be a positive integer.", e);
            }
        } else {
            throw new RPCServerInitializationException("Timeout milliseconds parameter not specified in application configuration.");
        }
        String lts = this.propertyMgr.getProperty(XP_RPC_LINGER_TIME_SECS).getAttribute(ATTR_VALUE);
        if (lts != null && lts.length() > 0) {
            try {
                lingerTimeSeconds = Integer.parseInt(tom);
            }
            catch (NumberFormatException e) {
                throw new RPCServerInitializationException("The linger time seconds configuration paramter must be a positive integer.", e);
            }
        }
        if ((rhc = this.propertyMgr.getProperty(XP_REQUEST_HANDLER_CLASS).getAttribute(ATTR_VALUE)) != null && rhc.length() > 0) {
            try {
                requestHandler = Class.forName(rhc);
            }
            catch (ClassNotFoundException e) {
                throw new RPCServerInitializationException("An error occurred while loading handler class for RPC server.", e);
            }
        } else {
            throw new RPCServerInitializationException("Request handler configuration parameter not specified in application configuration.");
        }
        String rbc = this.propertyMgr.getProperty(XP_REQUEST_BROKER_CLASS).getAttribute(ATTR_VALUE);
        if (rbc != null && rbc.length() > 0) {
            try {
                requestBroker = Class.forName(rbc);
            }
            catch (ClassNotFoundException e) {
                throw new RPCServerInitializationException("An error occurred while loading broker class for RPC server.", e);
            }
        } else {
            throw new RPCServerInitializationException("Request broker configuration parameter not specified in application configuration.");
        }
    }

    public void run() {
        try {
            this.loadProperties();
            handlers = new RequestHandlerPool((PoolableObjectFactory)new PoolableRequestHandlerObjectFactory(requestHandler, requestBroker), maxHandlers);
            ServerSocket serverSocket = new ServerSocket(port);
            Socket s = null;
            while (true) {
                s = serverSocket.accept();
                RequestHandler handler = (RequestHandler)handlers.borrowObject();
                handler.setSocket(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IMSException.getIMSException("An error occurred during RPC server operation.", e);
            return;
        }
    }

    public static ObjectPool getHandlers() {
        return handlers;
    }

    public static int getTimeoutMilliseconds() {
        return timeoutMilliseconds;
    }

    public static int getLingerTimeSeconds() {
        return lingerTimeSeconds;
    }
}

