/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.server;

import gov.va.med.hds.hdr.common.net.MllpNetworkClient;
import gov.va.med.hds.hdr.common.rpc.broker.RequestBroker;
import gov.va.med.hds.hdr.common.rpc.server.RequestHandler;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class ER7ProtocolHandler
extends RequestHandler {
    private static final char SEGMENT_DELIMETER = '\r';
    private static final byte SOB = 11;
    private static final byte EOB = 28;

    public ER7ProtocolHandler(Class brokerClass) {
        super(brokerClass);
    }

    protected void handleRequest(InputStream in, PrintStream out) throws Exception {
        StringBuffer request = new StringBuffer();
        boolean foundSob = false;
        Object line = null;
        int next = -1;
        while ((next = in.read()) != -1) {
            if (request.length() == 0 && (next == 10 || next == 13)) continue;
            if (next == 11) {
                foundSob = true;
                continue;
            }
            if (next == 28) {
                foundSob = false;
                break;
            }
            if (next == 10) {
                next = 13;
            }
            if (!foundSob) continue;
            request.append((char)next);
        }
        if (request != null && request.length() > 0) {
            RequestBroker broker = (RequestBroker)this.brokerClass.newInstance();
            String response = new String(broker.invoke(ByteBuffer.wrap(request.toString().getBytes())).array());
            out.write(MllpNetworkClient.mllpEncode(response).getBytes());
        }
    }
}

