/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.response.xslt;

import gov.va.med.hds.hdr.common.rpc.response.ResponseAdapter;
import gov.va.med.hds.hdr.common.rpc.response.ResponseAdapterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Text;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.xml.sax.InputSource;

public class XSLTResponseAdapter
implements ResponseAdapter {
    private static final Map<File, Templates> TEMPLATE_MAP = new Hashtable<File, Templates>();
    private Templates templates = null;

    public XSLTResponseAdapter(String styleSheet) throws ResponseAdapterException {
        this(new File(styleSheet));
    }

    public XSLTResponseAdapter(File styleSheet) throws ResponseAdapterException {
        this.templates = TEMPLATE_MAP.get(styleSheet.getAbsoluteFile());
        try {
            if (this.templates == null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                SAXSource s = new SAXSource(new InputSource(new BufferedReader(new FileReader(styleSheet))));
                this.templates = factory.newTemplates(s);
                TEMPLATE_MAP.put(styleSheet, this.templates);
            }
        }
        catch (Exception e) {
            throw new ResponseAdapterException("An error occurred while instantiating the response adapter.", e);
        }
    }

    public String adapt(String data) throws ResponseAdapterException {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)data);
        }
        catch (Exception e) {
            throw new ResponseAdapterException("An error occurred while adapting the input.", e);
        }
        return this.adapt(document);
    }

    public String adapt(Document aDocument) throws ResponseAdapterException {
        String output = "";
        try {
            if (this.templates == null) {
                throw new Exception("The templates object is null.");
            }
            Transformer t = this.templates.newTransformer();
            DocumentSource source = new DocumentSource(aDocument);
            DocumentResult result = new DocumentResult();
            t.transform((Source)source, (Result)result);
            List l = result.getDocument().content();
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o instanceof Text) {
                    output = output + ((Text)o).getText();
                    continue;
                }
                if (!(o instanceof Element)) continue;
                output = output + ((Element)o).asXML();
            }
            return output;
        }
        catch (Exception e) {
            throw new ResponseAdapterException("An error occurred while adapting the input.", e);
        }
    }
}

