/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.response;

import gov.va.med.hds.hdr.common.rpc.response.ResponseAdapter;
import gov.va.med.hds.hdr.common.rpc.response.ResponseAdapterException;
import gov.va.med.hds.hdr.common.rpc.response.xslt.XSLTResponseAdapter;

public class ResponseAdapterFactory {
    private static final String EXT_XSL = ".xsl";
    private static ResponseAdapterFactory instance = null;

    private ResponseAdapterFactory() {
    }

    public static final ResponseAdapterFactory getInstance() {
        if (instance == null) {
            instance = new ResponseAdapterFactory();
        }
        return instance;
    }

    public ResponseAdapter createResponseAdapter(String styleSheet) throws ResponseAdapterException {
        if (styleSheet == null) {
            throw new ResponseAdapterException("A result adapter cannot be created for a null stylesheet.");
        }
        if (styleSheet.endsWith(EXT_XSL)) {
            return new XSLTResponseAdapter(styleSheet);
        }
        throw new ResponseAdapterException("There is no response adapter for style sheets with the extension '" + styleSheet.substring(styleSheet.lastIndexOf(46)) + "'.");
    }
}

