/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.command.queryaccess;

import java.util.GregorianCalendar;

public class HL7DateTime {
    private String yyyy;
    private String mm;
    private String dd;
    private String hh;
    private String mins;
    private String ss;
    private static String[] lastDayOfTheMonths = new String[]{"31", "28", "31", "30", "31", "30", "31", "31", "30", "31", "30", "31"};
    private StringBuffer dateBuffer = new StringBuffer();

    public String formatStartDate(String dateTime) {
        int dateTimeLength = dateTime.length();
        if (dateTime != null && dateTimeLength == 0) {
            return "18000101";
        }
        this.parseDateTime(dateTime);
        this.dateBuffer.setLength(0);
        this.dateBuffer.append(this.yyyy);
        if (this.mm != null && !this.mm.equals("00")) {
            this.dateBuffer.append(this.mm);
        } else {
            this.dateBuffer.append("01");
        }
        if (this.dd != null && !this.dd.equals("00")) {
            this.dateBuffer.append(this.dd);
        } else {
            this.dateBuffer.append("01");
        }
        if (this.hh != null) {
            this.dateBuffer.append(this.hh);
            if (this.mins != null) {
                this.dateBuffer.append(this.mins);
            } else {
                this.dateBuffer.append("00");
            }
            if (this.ss != null) {
                this.dateBuffer.append(this.ss);
            } else {
                this.dateBuffer.append("00");
            }
        }
        return this.dateBuffer.toString();
    }

    public String formatEndDate(String dateTime) {
        int dateTimeLength = dateTime.length();
        if (dateTime != null && dateTimeLength == 0) {
            return "25001231235959";
        }
        this.parseDateTime(dateTime);
        this.dateBuffer.setLength(0);
        this.dateBuffer.append(this.yyyy);
        if (this.mm != null && !this.mm.equals("00")) {
            this.dateBuffer.append(this.mm);
        } else {
            this.mm = "12";
            this.dateBuffer.append(this.mm);
        }
        if (this.dd != null && !this.dd.equals("00")) {
            this.dateBuffer.append(this.dd);
        } else {
            String lastDayOfTheMonth = this.getLastDayOfTheMonth(this.yyyy, this.mm);
            this.dateBuffer.append(lastDayOfTheMonth);
        }
        if (this.hh != null) {
            this.dateBuffer.append(this.hh);
            if (this.mins != null) {
                this.dateBuffer.append(this.mins);
            } else {
                this.dateBuffer.append("59");
            }
            if (this.ss != null) {
                this.dateBuffer.append(this.ss);
            } else {
                this.dateBuffer.append("59");
            }
        } else {
            this.dateBuffer.append("235959");
        }
        return this.dateBuffer.toString();
    }

    private void parseDateTime(String dateTime) {
        if (null != dateTime && 0 < dateTime.length()) {
            this.clearDateTime();
            dateTime = this.stripUnused(dateTime);
            int dateTimeLength = dateTime.length();
            if (dateTimeLength <= 8) {
                this.parseDate(dateTime);
            } else {
                this.parseDate(dateTime.substring(0, 8));
                this.parseTime(dateTime.substring(8, dateTimeLength));
            }
        }
    }

    private boolean isLeapyear(String yearString) {
        int year = Integer.parseInt(yearString);
        return new GregorianCalendar().isLeapYear(year);
    }

    private void parseDate(String aDate) {
        String date = aDate;
        int dateLength = date.length();
        if (dateLength % 2 != 0) {
            date = date + '0';
            ++dateLength;
        }
        if (dateLength == 4) {
            this.yyyy = date;
        } else if (dateLength == 6) {
            this.yyyy = date.substring(0, 4);
            this.mm = date.substring(4, 6);
        } else if (dateLength == 8) {
            this.yyyy = date.substring(0, 4);
            this.mm = date.substring(4, 6);
            this.dd = date.substring(6, 8);
        }
    }

    private void parseTime(String aTime) {
        String time = aTime;
        int timeLength = time.length();
        if (timeLength % 2 != 0) {
            time = time + '0';
            ++timeLength;
        }
        if (timeLength == 2) {
            this.hh = time;
        } else if (timeLength == 4) {
            this.hh = time.substring(0, 2);
            this.mins = time.substring(2, 4);
        } else if (timeLength == 6) {
            this.hh = time.substring(0, 2);
            this.mins = time.substring(2, 4);
            this.ss = time.substring(4, 6);
        }
    }

    private String stripUnused(String aDate) {
        int index = -1;
        String strippedDate = aDate;
        index = aDate.indexOf(46);
        if (index != -1) {
            strippedDate = aDate.substring(0, index);
        } else {
            index = aDate.indexOf(45);
            if (index != -1 || (index = aDate.indexOf(43)) != -1) {
                strippedDate = aDate.substring(0, index);
            }
        }
        return strippedDate;
    }

    private String getLastDayOfTheMonth(String yyyy, String mm) {
        int month = Integer.parseInt(mm);
        if (month == 2) {
            if (this.isLeapyear(yyyy)) {
                return "29";
            }
            return "28";
        }
        return lastDayOfTheMonths[month - 1];
    }

    public void clearDateTime() {
        this.yyyy = null;
        this.mm = null;
        this.dd = null;
        this.hh = null;
        this.mins = null;
        this.ss = null;
    }

    public String toString() {
        return "yyyy " + this.yyyy + " mm " + this.mm + " dd " + this.dd + " hh " + this.hh + " mins " + this.mins + " ss " + this.ss;
    }

    public static void main(String[] args) {
        String aDate = "200002";
        if (args.length == 1) {
            aDate = args[0];
        }
        HL7DateTime hL7DateTime = new HL7DateTime();
        System.out.println(hL7DateTime.formatStartDate(aDate));
        System.out.println(hL7DateTime.formatEndDate(aDate));
    }
}

