/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.command.queryaccess;

import gov.va.med.hds.hdr.common.adapter.AdaptationException;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.adapter.IncompatibleInputException;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterException;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterFactory;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.HL7Message;
import java.io.IOException;
import org.dom4j.Document;

public class HL72JDOMDocumentAdapterFactory
implements AdapterFactory {
    private String templateName = null;

    public HL72JDOMDocumentAdapterFactory(String templateName) {
        this.templateName = templateName;
    }

    public Adapter createAdapter() {
        return new HL72JDOMDocumentAdapter(this.templateName);
    }

    protected class HL72JDOMDocumentAdapter
    implements Adapter {
        private String templateName = null;
        private HL7Message inputSource = null;
        private Document result = null;

        public HL72JDOMDocumentAdapter(String templateName) {
            this.templateName = templateName;
        }

        public void adapt() throws AdaptationException {
            try {
                ResultAdapter resultAdapter = ResultAdapterFactory.createResultAdapter(this.inputSource.getMessage());
                this.result = (Document)resultAdapter.adapt(this.inputSource.getMessage(), this.templateName);
            }
            catch (ResultAdapterException e) {
                throw new AdaptationException(e);
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public void setInput(Object obj) throws IncompatibleInputException, IOException {
            if (obj == null || !(obj instanceof HL7Message)) {
                throw new IncompatibleInputException("The input type " + obj.getClass().getName() + " is not supported by this adapter.");
            }
            this.inputSource = (HL7Message)obj;
        }
    }
}

