/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.command.queryaccess;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.adapter.xslt.HxXML2HL7MessageAdapterFactory;
import gov.va.med.hds.hdr.common.rpc.command.queryaccess.CDSPatientObservationsByTypeAndTimespanCommand;
import gov.va.med.hds.hdr.common.rpc.command.queryaccess.HL7NoOpAdapterFactory;
import gov.va.med.hds.hdr.common.rpc.response.CHDRResponseObject;
import gov.va.med.hds.hdr.common.util.Checksum;
import gov.va.med.hds.hdr.service.queryaccess.QueryAccessException;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.HL7Message;
import java.util.AbstractMap;
import java.util.Iterator;

public class CHDRPatientObservationsByTypeAndTimespanCommand
extends CDSPatientObservationsByTypeAndTimespanCommand {
    private static final String XP_HX_CHDR_STYLESHEET = "templates/template[@name='TEMPLATE_NAME']/stylesheet[@output='HL7']/@path";

    public CHDRPatientObservationsByTypeAndTimespanCommand(PropertyElement entryPoint) {
        super(entryPoint);
    }

    protected AdapterFactory createAdapterFactory(String domain) throws QueryAccessException {
        AdapterFactory adapterFactory = null;
        if (domain != null && domain.startsWith("FHIE.GOV/VA")) {
            adapterFactory = new HL7NoOpAdapterFactory();
        } else if (domain != null && domain.startsWith("FHIE.GOV/HX")) {
            String xpath = XP_HX_CHDR_STYLESHEET.replaceFirst("TEMPLATE_NAME", this.getTemplate());
            PropertyMgr pm = PropertyMgr.getInstance(domain);
            String styleSheet = pm.getProperty(xpath).getValue();
            adapterFactory = new HxXML2HL7MessageAdapterFactory(styleSheet);
        }
        return adapterFactory;
    }

    protected String preProcessICN(String aICN) {
        String icn = Checksum.addChecksumToIcn(aICN);
        return icn;
    }

    protected String buildKey(Object aObject) throws Exception {
        HL7Message hL7Message = (HL7Message)aObject;
        String key = null;
        this.workBuffer.setLength(0);
        this.workBuffer.append(hL7Message.getStationNumber()).append("_");
        this.workBuffer.append(hL7Message.getClinicalId());
        key = this.workBuffer.toString();
        return key;
    }

    protected Object buildObservationsDocument(AbstractMap observations) throws QueryAccessException {
        this.workBuffer.setLength(0);
        Iterator iter = observations.keySet().iterator();
        HL7Message hL7Message = null;
        String message = null;
        try {
            while (iter.hasNext()) {
                String key = (String)iter.next();
                hL7Message = (HL7Message)observations.get(key);
                message = hL7Message.getMessage().trim();
                this.workBuffer.append("\n").append(message);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Exception: " + ex.getMessage());
            throw new QueryAccessException(ex.getMessage());
        }
        CHDRResponseObject cHDRResponseObject = new CHDRResponseObject();
        cHDRResponseObject.setObservations(this.workBuffer.toString());
        cHDRResponseObject.setErrors(this.errors);
        return cHDRResponseObject;
    }

    protected String getClinicallyRelevantDate(Object aObject) throws Exception {
        String returnValue = "";
        return returnValue;
    }
}

