/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.command.queryaccess;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.rpc.command.CommandExecutionException;
import gov.va.med.hds.hdr.common.rpc.command.queryaccess.AbstractQueryAccessCommand;
import gov.va.med.hds.hdr.common.rpc.command.queryaccess.HL7DateTime;
import gov.va.med.hds.hdr.common.util.StringHelper;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.ServiceUnavailableException;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.queryaccess.ClinicalQueryAccess;
import gov.va.med.hds.hdr.service.queryaccess.ClinicalQueryAccessImpl;
import gov.va.med.hds.hdr.service.queryaccess.PatientNotKnownException;
import gov.va.med.hds.hdr.service.queryaccess.QueryAccessException;
import gov.va.med.hds.hdr.service.rules.RulesEngine;
import gov.va.med.hds.hdr.service.session.ImsSession;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CDSPatientObservationsByTypeAndTimespanCommand
extends AbstractQueryAccessCommand {
    public static final boolean LOG_AUDIT = true;
    public static final boolean LOG_ACCOUNTING = true;
    public static final String ERRORS_ELEMENT_NAME = "errors";
    public static final String ERROR_ELEMENT_NAME = "error";
    private static final String GRAPH_PATH = "graph";
    private static final String LOCAL_NAME_PATH = "graph/attribute[@name='origination' and @type='QualifiedName']/field[@name='local_name']";
    private static final String PATIENT_ICN_UNKNOWN = "Patient ICN unknown: ";
    private static final String DEFAULT_START_DATE = "18000101000000.000-0000";
    private static final String DEFAULT_END_DATE = "25001231235959.000-0000";
    public static final long ONE_DAY = 86400000L;
    protected static RulesEngine rulesEngine;
    protected HashSet observationKeys = new HashSet();
    protected AbstractMap<String, Object> mergedPatientData = new HashMap<String, Object>();
    protected StringBuffer workBuffer = new StringBuffer();
    protected String icn;
    protected String template;
    protected String startTime;
    protected String stopTime;
    protected String requestingFacility;
    protected boolean icnDataFound = false;
    protected String[] errorMessages;
    protected ArrayList<String> errors;

    public CDSPatientObservationsByTypeAndTimespanCommand(PropertyElement entryPoint) {
        super(entryPoint);
    }

    public Object execute(Document request) throws CommandExecutionException {
        try {
            if (rulesEngine == null) {
                rulesEngine = ServiceLocator.getInstance().getRulesEngine();
            }
            this.definePatientQueryParameters(request);
            this.icnDataFound = false;
            String masterDomain = this.getDomain();
            this.getDomainPatientData(masterDomain, null);
            String domains = this.getAdditionalDomains();
            if (domains != null) {
                String[] additionalDomains = StringHelper.split((String)this.getAdditionalDomains(), (String)":");
                for (int i = 0; i < additionalDomains.length; ++i) {
                    this.getDomainPatientData(masterDomain, additionalDomains[i]);
                }
            }
            if (!this.icnDataFound) {
                if (this.errors == null) {
                    this.errors = new ArrayList();
                }
                this.errors.add(PATIENT_ICN_UNKNOWN + this.icn);
            }
            return this.buildObservationsDocument(this.mergedPatientData);
        }
        catch (ServiceUnavailableException sue) {
            throw new CommandExecutionException("An error occurred locating rules engine service.", sue);
        }
        catch (Exception e) {
            Throwable throwable = e.getCause();
            String errorMessage = "";
            errorMessage = throwable != null ? throwable.getMessage() : e.getMessage();
            throw new CommandExecutionException(errorMessage, e);
        }
    }

    private void getDomainPatientData(String masterDomain, String aDomain) {
        block5: {
            Collection patientData = null;
            try {
                patientData = this.getCQAPatientObservations(masterDomain, aDomain);
                if (patientData.size() > 0) {
                    this.mergeDomainData(patientData);
                }
                this.icnDataFound = true;
            }
            catch (PatientNotKnownException pnke) {
            }
            catch (Exception imse) {
                this.errorMessages = rulesEngine.getErrorMessages(imse);
                if (this.errorMessages.length <= 0) break block5;
                if (this.errors == null) {
                    this.errors = new ArrayList();
                }
                this.errors.addAll(Arrays.asList(this.errorMessages));
            }
        }
    }

    protected String preProcessICN(String aICN) {
        return aICN;
    }

    protected String adjustTimeByMilliseconds(String aDate, long aMillisecondsToIncreaseBy) throws Exception {
        String aNewStopTime = "";
        int dateLength = aDate.length();
        String aDateTimeZone = "";
        TimeZone timeZone = null;
        int timeZoneIndex = aDate.indexOf(45);
        if (timeZoneIndex != -1 || (timeZoneIndex = aDate.indexOf(43)) != -1) {
            aDateTimeZone = aDate.substring(timeZoneIndex);
            timeZone = TimeZone.getTimeZone("GMT" + aDateTimeZone);
        } else {
            timeZone = TimeZone.getTimeZone("GMT");
            aDate = aDate + "-0000";
        }
        long newTime = DateTimeUtility.getMilliSecond(aDate);
        aNewStopTime = DateTimeUtility.getISOTime(newTime += aMillisecondsToIncreaseBy, timeZone);
        aNewStopTime = aNewStopTime.substring(0, dateLength);
        return aNewStopTime;
    }

    protected void definePatientQueryParameters(Document request) throws Exception {
        this.icn = this.preProcessICN(this.getICN(request));
        this.template = this.getTemplate();
        this.startTime = this.getStartTime(request);
        this.stopTime = this.getStopTime(request);
        if (this.startTime.length() == 0 || this.isStartDateIgnored()) {
            this.startTime = DEFAULT_START_DATE;
        }
        if (this.stopTime.length() == 0 || this.isStopDateIgnored()) {
            this.stopTime = DEFAULT_END_DATE;
        }
        this.requestingFacility = this.getRequestingFacility(request);
        HL7DateTime hL7DateTime = new HL7DateTime();
        this.startTime = hL7DateTime.formatStartDate(this.startTime);
        this.stopTime = hL7DateTime.formatEndDate(this.stopTime);
        ClinicalQueryAccessImpl.validateTimespan(this.startTime, this.stopTime);
        this.startTime = this.adjustTimeByMilliseconds(this.startTime, -86400000L);
        this.stopTime = this.adjustTimeByMilliseconds(this.stopTime, 86400000L);
    }

    private Collection getCQAPatientObservations(String masterDomain, String aDataDomain) throws ServiceUnavailableException, QueryAccessException, DataAccessException {
        String currentDomain = aDataDomain == null ? masterDomain : aDataDomain;
        AdapterFactory adapterFactory = this.createAdapterFactory(currentDomain);
        ClinicalQueryAccess clinicalQueryAccess = ServiceLocator.getInstance().getClinicalQueryAccessService(currentDomain);
        Collection c = clinicalQueryAccess.getPatientObservations(this.icn, this.template, this.startTime, this.stopTime, this.requestingFacility, adapterFactory);
        return c;
    }

    protected void mergeDomainData(Collection aCollection) throws Exception {
        String key = null;
        StringBuffer keyBuffer = new StringBuffer();
        Object data2 = null;
        for (Object data2 : aCollection) {
            keyBuffer.setLength(0);
            key = this.buildKey(data2);
            if (this.mergedPatientData.containsKey(key)) continue;
            this.mergedPatientData.put(key, data2);
        }
    }

    protected String getClinicallyRelevantDate(Object aObject) throws Exception {
        Document document = (Document)aObject;
        Element graph = null;
        Attribute clinicallyRelevantDate = null;
        String returnValue = null;
        graph = (Element)document.selectSingleNode(GRAPH_PATH);
        clinicallyRelevantDate = graph.attribute("clinicallyRelevantDate");
        if (clinicallyRelevantDate == null) {
            throw new QueryAccessException("clinicallyRelevantDate (" + clinicallyRelevantDate + ") is not available and is a required attribute for each graph element.");
        }
        returnValue = DateTimeUtility.formatISODate(clinicallyRelevantDate.getValue().trim(), "yyyyMMddHHmmssZ");
        return returnValue;
    }

    protected String buildKey(Object aObject) throws Exception {
        Document document = (Document)aObject;
        Element localName = null;
        String key = null;
        localName = (Element)document.selectSingleNode(LOCAL_NAME_PATH);
        if (localName == null) {
            throw new QueryAccessException("LocalName (" + localName + ") is not available and is required for the unique key.");
        }
        key = localName.getText().trim();
        return key;
    }

    protected Object buildObservationsDocument(AbstractMap observations) throws QueryAccessException {
        Document observationsDocument = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"observations"));
        Element observationsRoot = observationsDocument.getRootElement();
        observationsRoot.addAttribute("templateName", this.getTemplate());
        Iterator iter = observations.keySet().iterator();
        Document document = null;
        Element element = null;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            document = (Document)observations.get(key);
            element = (Element)document.getRootElement().detach();
            observationsRoot.add(element);
        }
        if (this.errors != null && this.errors.size() > 0) {
            ImsSession session = ServiceLocator.getInstance().getImsSession();
            if (null != session) {
                session.doException(this.errors);
            }
            Document errorDocument = this.buildErrorDocument(this.errors);
            element = (Element)errorDocument.getRootElement().detach();
            observationsDocument.getRootElement().add(element);
        }
        return observationsDocument;
    }

    protected Document buildErrorDocument(Collection aErrorList) {
        Document errorsDocument = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)ERRORS_ELEMENT_NAME));
        Element errorsRoot = errorsDocument.getRootElement();
        Iterator iter = aErrorList.iterator();
        Element errorElement = null;
        while (iter.hasNext()) {
            String errorMessage = (String)iter.next();
            errorElement = DocumentHelper.createElement((String)ERROR_ELEMENT_NAME);
            errorElement.setText(errorMessage);
            errorsRoot.add(errorElement);
        }
        return errorsDocument;
    }
}

