/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.command.queryaccess;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.adapter.xslt.HxXML2TemplateXMLAdapterFactory;
import gov.va.med.hds.hdr.common.rpc.command.Command;
import gov.va.med.hds.hdr.common.rpc.command.queryaccess.HL72JDOMDocumentAdapterFactory;
import gov.va.med.hds.hdr.service.queryaccess.QueryAccessException;
import java.util.Collection;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractQueryAccessCommand
implements Command {
    private static final String P_PARAM_ICN = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='icn' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String P_PARAM_WHAT = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='what' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String P_PARAM_MAX = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='maxReturn' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String P_PARAM_START = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='startDate' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String P_PARAM_STOP = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='stopDate' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String P_SENDING_FACILITY = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/attribute[@name='sendingFacility' and @type='PlainText']/field[@name='value']";
    private static final String DOMAIN_ELEMENT = "domain";
    private static final String ADDITIONAL_DOMAINS_ELEMENT = "additionalDomains";
    private static final String START_DATE_IGNORED_ELEMENT = "startDateIgnored";
    private static final String STOP_DATE_IGNORED_ELEMENT = "stopDateIgnored";
    private static final String TEMPLATE_ELEMENT = "template";
    protected static final String HX_DOMAIN_ID = "FHIE.GOV/HX";
    protected static final String VA_DOMAIN_ID = "FHIE.GOV/VA";
    private static final String XP_STYLESHEET = "templates/template[@name='TEMPLATE_NAME']/stylesheet[@output='XML']/@path";
    protected static final int DOMAIN_INDEX = 0;
    private PropertyElement entryPoint = null;

    public AbstractQueryAccessCommand(PropertyElement entryPoint) {
        this.entryPoint = entryPoint;
    }

    private String getDocumentValue(Document document, String path) throws QueryAccessException {
        String documentValue = null;
        Node node = document.selectSingleNode(path);
        if (node != null) {
            documentValue = node.getText();
        }
        return documentValue;
    }

    protected String getWhatCode(Document d) throws QueryAccessException {
        return this.getDocumentValue(d, P_PARAM_WHAT);
    }

    protected String getDomain() throws QueryAccessException {
        return this.entryPoint.getChildProperties(DOMAIN_ELEMENT)[0].getValue();
    }

    protected AdapterFactory createAdapterFactory(String domain) throws QueryAccessException {
        AdapterFactory adapterFactory = null;
        if (domain != null && domain.startsWith(VA_DOMAIN_ID)) {
            adapterFactory = new HL72JDOMDocumentAdapterFactory(this.getTemplate());
        } else if (domain != null && domain.startsWith(HX_DOMAIN_ID)) {
            String xpath = XP_STYLESHEET.replaceFirst("TEMPLATE_NAME", this.getTemplate());
            PropertyMgr pm = PropertyMgr.getInstance(domain);
            String styleSheet = pm.getProperty(xpath).getValue();
            adapterFactory = new HxXML2TemplateXMLAdapterFactory(styleSheet);
        }
        return adapterFactory;
    }

    protected String getAdditionalDomains() throws QueryAccessException {
        String additionalDomain = null;
        PropertyElement[] propertyElements = this.entryPoint.getChildProperties(ADDITIONAL_DOMAINS_ELEMENT);
        if (propertyElements.length > 0 && (additionalDomain = propertyElements[0].getValue()).equals("")) {
            additionalDomain = null;
        }
        return additionalDomain;
    }

    protected boolean isStopDateIgnored() throws QueryAccessException {
        return Boolean.valueOf(this.entryPoint.getChildProperties(STOP_DATE_IGNORED_ELEMENT)[0].getValue());
    }

    protected boolean isStartDateIgnored() throws QueryAccessException {
        return Boolean.valueOf(this.entryPoint.getChildProperties(START_DATE_IGNORED_ELEMENT)[0].getValue());
    }

    protected String getTemplate() throws QueryAccessException {
        return this.entryPoint.getChildProperties(TEMPLATE_ELEMENT)[0].getValue();
    }

    protected String getICN(Document d) throws QueryAccessException {
        return this.getDocumentValue(d, P_PARAM_ICN);
    }

    protected String getMaxReturn(Document d) throws QueryAccessException {
        return this.getDocumentValue(d, P_PARAM_MAX);
    }

    protected String getStartTime(Document d) throws QueryAccessException {
        return this.getDocumentValue(d, P_PARAM_START);
    }

    protected String getStopTime(Document d) throws QueryAccessException {
        return this.getDocumentValue(d, P_PARAM_STOP);
    }

    protected String getRequestingFacility(Document d) throws QueryAccessException {
        return this.getDocumentValue(d, P_SENDING_FACILITY);
    }

    protected Object buildObservationsDocument(Collection observations) throws QueryAccessException {
        Document observationsDocument = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"observations"));
        Element observationsRoot = observationsDocument.getRootElement();
        observationsRoot.addAttribute("templateName", this.getTemplate());
        Iterator iter = observations.iterator();
        Document d = null;
        Element e = null;
        while (iter.hasNext()) {
            d = (Document)iter.next();
            e = (Element)d.getRootElement().detach();
            observationsRoot.add(e);
        }
        return observationsDocument;
    }
}

