/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.broker;

import gov.va.med.hds.hdr.common.rpc.broker.CDSDefaultClientBroker;
import java.nio.ByteBuffer;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RDVClientBroker
extends CDSDefaultClientBroker {
    public static final String TABLE_ROW_DATA_SEGMENT = "RDT";
    public static final String RDV_ERROR = "ERROR::";
    protected static final String XP_ERRORONREQUEST_PROPERTY = "errorOnRequest";

    protected ByteBuffer handleUnusableRequestError(Exception aException) {
        String message = "An error occurred parsing the client request, Exception: EXCEPTION".replaceFirst("EXCEPTION", aException.getMessage());
        this.workBuffer.append("MSA").append("^");
        this.workBuffer.append("AE").append("^");
        this.workBuffer.append(this.originalMessageControlId).append("^");
        this.workBuffer.append(message);
        this.workBuffer.append("ERR").append("^OBR~~~207&").append(message).append("\n");
        this.workBuffer.append("QAK").append("^").append(this.queryTag).append("^OK\n");
        this.workBuffer.append("RDF").append("^");
        this.workBuffer.append("1").append("^").append("\n");
        this.workBuffer.append(RDV_ERROR).append(message).append("\n");
        return ByteBuffer.wrap(this.workBuffer.toString().getBytes());
    }

    protected void handleCommandCreationError() {
        this.buildErrorResponse("An error occurred creating the command object, Entry point: WHAT_CODE".replaceFirst("WHAT_CODE", this.whatCode), "AE");
    }

    protected void handleCommandExecutionError(Exception aException) {
        this.buildErrorResponse("An error occurred during the execution of the command object, Exception: EXCEPTION".replaceFirst("EXCEPTION", aException.getMessage()), "AR");
    }

    protected void buildErrorResponse(String aErrorMessage) {
        this.buildErrorResponse(aErrorMessage, "");
    }

    protected void buildErrorResponse(String aErrorMessage, String aAcknowledgmentCode) {
        this.errorElement = DocumentHelper.createElement((String)"error");
        this.errorElement.setText(aErrorMessage);
        this.errorElement.addAttribute("AckCode", aAcknowledgmentCode);
        this.queryResultsDocument = DocumentHelper.createDocument((Element)this.errorElement);
        this.queryResults = this.queryResultsDocument;
        this.entryPoint = this.propertyMgr.getProperty("transformer/rpcbroker[@type='HL7' and @encoding='ER7']/entry-point[@code='WHAT_CODE']".replaceFirst("WHAT_CODE", "ERROR"));
    }

    protected void handleBuildClientResponseError(Exception aException) {
        this.workBuffer.append("MSA").append("^");
        this.workBuffer.append("AE").append("^");
        this.workBuffer.append(this.originalMessageControlId).append("^");
        this.workBuffer.append("An error occurred processing the response").append("\n");
        this.workBuffer.append("QAK").append("^").append(this.queryTag).append("^OK\n");
        this.workBuffer.append("ERR").append("^OBR~~~207&").append("RDVClientBroker response build exception: ").append(aException.getMessage()).append("\n");
        this.workBuffer.append("RDF").append("^");
        this.workBuffer.append("1").append("^").append("\n");
        this.workBuffer.append(TABLE_ROW_DATA_SEGMENT).append("^");
        this.workBuffer.append("1").append("^");
        this.workBuffer.append(RDV_ERROR).append(aException.getMessage()).append("\n");
        this.response = this.workBuffer.toString();
    }
}

