/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.broker;

import gov.fhie.common.logger.AuditLocalThread;
import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.rpc.broker.ClientBrokerFactory;
import gov.va.med.hds.hdr.common.rpc.broker.ClientRequestBroker;
import gov.va.med.hds.hdr.common.rpc.broker.InvalidParameterException;
import gov.va.med.hds.hdr.common.rpc.broker.InvocationException;
import gov.va.med.hds.hdr.common.rpc.broker.RequestBroker;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterFactory;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import org.dom4j.Document;
import org.dom4j.Element;

public class ER7RequestBroker
implements RequestBroker {
    public static final String ELEMENT = "ELEMENT";
    private static final String XP_RPCTEMPLATE = "transformer/mapping-type-codes/mapping-type-code[@message-type='MESSAGE_TYPE']/@template";
    private static final String XP_WHO = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='who' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String XP_WHATCODE = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='what' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String XP_QUERY_TAG = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/attribute[@name='queryTag' and @type='PlainText']/field[@name='value']";
    private static final String XP_MESSAGE_CONTROL_ID = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/attribute[@name='messageControlId' and @type='PlainText']/field[@name='value']";
    private static final String XP_SENDING_APPLICATION = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/attribute[@name='sendingApplication' and @type='PlainText']/field[@name='value']";
    private static final String XP_RECEIVING_APPLICATION = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/attribute[@name='receivingApplication' and @type='PlainText']/field[@name='value']";
    private static final String XP_SENDING_FACILITY = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/attribute[@name='sendingFacility' and @type='PlainText']/field[@name='value']";
    private static final String XP_RECEIVING_FACILITY = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/attribute[@name='receivingFacility' and @type='PlainText']/field[@name='value']";
    private static final String MESSAGE_TYPE = "MESSAGE_TYPE";
    private static final String ELEMENT_NOT_FOUND_IN_REQUEST = "Could not find request element 'ELEMENT'";
    private static final String ELEMENT_NOT_FOUND_IN_GRAPH = "Could not find element in graph.\nGraph: \n";
    private static final String ERROR_ON_MESSAGE_TYPE = "There is no mapping type code for message type of MESSAGE_TYPE.Please update the mapping type codes in the application configuraiton file and restart the framework.";
    private ResultAdapter resultAdapter;
    private PropertyElement rpcTemplateElement;
    private PropertyMgr propertyMgr;
    private Document requestDocument;
    private Element who;
    private Element whatCode;
    private Element queryTag;
    private Element originalMessageControlId;
    private Element sendingApplication;
    private Element sendingFacility;
    private Element receivingApplication;
    private Element receivingFacility;
    private String message;

    public PropertyMgr getPropertyMgr() {
        return this.propertyMgr;
    }

    public Document getRequestDocument() {
        return this.requestDocument;
    }

    public String getElementText(Element aElement) {
        String returnValue = "";
        if (null != aElement) {
            returnValue = aElement.getText();
        }
        return returnValue;
    }

    public String getWhatCode() {
        return this.getElementText(this.whatCode);
    }

    public String getQueryTag() {
        return this.getElementText(this.queryTag);
    }

    public String getOriginalMessageControlId() {
        return this.getElementText(this.originalMessageControlId);
    }

    public String getSendingApplication() {
        return this.getElementText(this.sendingApplication);
    }

    public String getSendingFacility() {
        return this.getElementText(this.sendingFacility);
    }

    public String getReceivingApplication() {
        return this.getElementText(this.receivingApplication);
    }

    public String getReceivingFacility() {
        return this.getElementText(this.receivingFacility);
    }

    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer invoke(ByteBuffer bMessage) {
        ClientRequestBroker clientRequestBroker = null;
        String messageType = null;
        String templateName = null;
        ByteBuffer response = ByteBuffer.wrap("".getBytes());
        try {
            this.propertyMgr = PropertyMgr.getInstance();
            this.message = new String(bMessage.array());
            this.resultAdapter = ResultAdapterFactory.createResultAdapter(this.message);
            messageType = this.resultAdapter.getMessageType(this.message);
            this.rpcTemplateElement = this.propertyMgr.getProperty(XP_RPCTEMPLATE.replaceAll(MESSAGE_TYPE, messageType));
            if (this.rpcTemplateElement == null || (templateName = this.rpcTemplateElement.getValue()).length() == 0) {
                throw new InvocationException(ERROR_ON_MESSAGE_TYPE.replaceAll(MESSAGE_TYPE, messageType));
            }
            this.requestDocument = (Document)this.resultAdapter.adapt(this.message, templateName);
            this.sendingApplication = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_SENDING_APPLICATION, true);
            this.sendingFacility = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_SENDING_FACILITY, false);
            this.receivingApplication = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_RECEIVING_APPLICATION, false);
            this.receivingFacility = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_RECEIVING_FACILITY, false);
            this.originalMessageControlId = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_MESSAGE_CONTROL_ID, true);
            this.whatCode = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_WHATCODE, true);
            this.who = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_WHO, false);
            clientRequestBroker = ClientBrokerFactory.createClientBroker(this.getSendingApplication(), this);
            if (!this.getSendingApplication().equals("CHDR SENDER") && !this.getSendingApplication().equals("CHDR LAB SENDER")) {
                this.queryTag = ER7RequestBroker.getDocumentElement(this.requestDocument, XP_QUERY_TAG, true);
            }
            clientRequestBroker.initialize(this);
            response = clientRequestBroker.invoke();
        }
        catch (Exception e) {
            IMSException.getIMSException(e, (CharSequence)this.message, "ER7RequestBroker.invoke", ErrorCode.SRVR_003, new String[]{this.getSendingApplication(), this.getReceivingApplication(), this.getWhatCode(), this.getOriginalMessageControlId()});
            if (clientRequestBroker != null) {
                response = clientRequestBroker.handleUnusableRequestError(e);
            }
        }
        finally {
            this.logQueryAudit(response);
        }
        return response;
    }

    private void logQueryAudit(ByteBuffer response) {
        Hashtable auditInfo = (Hashtable)AuditLocalThread.getAuditLocal().get();
        if (null != this.message) {
            auditInfo.put("requestMsg", this.message);
        }
        if (null != this.sendingApplication) {
            auditInfo.put("sendingApplication", this.sendingApplication.getTextTrim());
        }
        String facility = null;
        if (null != this.sendingFacility) {
            facility = this.sendingFacility.getTextTrim();
            auditInfo.put("sendingFacility", facility);
        }
        if (null != this.receivingApplication) {
            auditInfo.put("receivingApplication", this.receivingApplication.getTextTrim());
        }
        if (null != this.originalMessageControlId) {
            auditInfo.put("originalMessageControlId", this.originalMessageControlId.getTextTrim());
        }
        if (null != this.whatCode) {
            auditInfo.put("purpose", this.whatCode.getTextTrim());
        }
        if (null != this.who) {
            String xmlEscChar = Character.toString('\u00ff');
            String requesterString = this.who.getTextTrim().replaceAll(xmlEscChar + "F" + xmlEscChar, "~");
            if (null != requesterString) {
                auditInfo.put("requesterString", requesterString);
                String[] requesterInfo = requesterString.split("~", 3);
                auditInfo.put("requester", requesterInfo.length > 1 ? requesterInfo[1] : "");
                if (null == facility || 0 == facility.length()) {
                    auditInfo.put("sendingFacility", requesterInfo.length > 2 && 0 < requesterInfo[2].length() ? requesterInfo[2] : "No Facility");
                }
            }
        }
        if (null != response) {
            auditInfo.put("responseSize", new Integer(response.limit()));
            String[] segs = new String(response.array()).split("\\p{Cntrl}");
            auditInfo.put("responseLength", new Integer(segs.length));
        }
    }

    public static Element getDocumentElement(Document aRequestDocument, String aRequestElement, boolean aRequiredElement) throws InvalidParameterException {
        Element element = (Element)aRequestDocument.selectSingleNode(aRequestElement);
        if (aRequiredElement && null == element) {
            throw new InvalidParameterException(ELEMENT_NOT_FOUND_IN_REQUEST.replaceFirst(ELEMENT, aRequestElement));
        }
        return element;
    }
}

