/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.broker;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.rpc.broker.ER7RequestBroker;
import gov.va.med.hds.hdr.common.rpc.command.Command;
import gov.va.med.hds.hdr.common.rpc.command.CommandFactory;
import gov.va.med.hds.hdr.hl7.HL7DelimiterEncoder;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import java.nio.ByteBuffer;
import org.dom4j.Document;

public abstract class ClientRequestBroker {
    public static final String WHAT_CODE = "WHAT_CODE";
    public static final String EXCEPTION = "EXCEPTION";
    public static final String MESSAGE_HEADER_SEGMENT = "MSH";
    public static final String MESSAGE_ACKNOWLEDGMENT_SEGMENT = "MSA";
    public static final String ERROR_SEGMENT = "ERR";
    public static final String HL7_ERROR_CODE_TABLE_ID = "0357";
    public static final String FIXED_ERROR_SEGMENT_ID = "";
    public static final String HL7_SEGMENT_SEPARATOR = "\n";
    public static final String HL7_DELIMITERS = "^~|\\&";
    public static final String ERROR_CODE_ID = "100";
    public static final String ERROR_CODE_ID_CATCHALL = "207";
    public static final int HL7_FIELD_INDEX = 0;
    public static final int HL7_COMPONENT_INDEX = 1;
    public static final int HL7_REPEATING_FIELD_INDEX = 2;
    public static final int HL7_ESCAPE_INDEX = 3;
    public static final int HL7_SUBCOMPONENT_INDEX = 4;
    public static final String HL7_FIELD_SEPARATOR = "^~|\\&".substring(0, 1);
    public static final String HL7_COMPONENT_SEPARATOR = "^~|\\&".substring(1, 2);
    public static final String HL7_SUBCOMPONENT_SEPARATOR = "^~|\\&".substring(4, 5);
    public static final String HL7_REPEATING_FIELD_SEPARATOR = "^~|\\&".substring(2, 3);
    public static final String HL7_ESCAPE_CHARACTER = "^~|\\&".substring(3, 4);
    public static final String MESSAGE_CONTROL_ID = "TBR~R08";
    public static final String ACKNOWLEDGMENT_CODE = "AckCode";
    public static final String ACKNOWLEDGMENT_CODE_APPLICATION_ACCEPT = "AA";
    public static final String ACKNOWLEDGMENT_CODE_APPLICATION_ERROR = "AE";
    public static final String ACKNOWLEDGMENT_CODE_APPLICATION_REJECT = "AR";
    public static final String ACKNOWLEDGMENT_CODE_COMMON_ACCEPT = "CA";
    public static final String ACKNOWLEDGMENT_CODE_COMMON_ERROR = "CE";
    public static final String ACKNOWLEDGMENT_CODE_COMMON_REJECT = "CR";
    public static final String ERROR_PARSING_CLIENT_RPC = "An error occurred parsing the client request, Exception: EXCEPTION";
    public static final String ERROR_CREATING_COMMAND = "An error occurred creating the command object, Entry point: WHAT_CODE";
    public static final String ERROR_EXECUTING_COMMAND = "An error occurred during the execution of the command object, Exception: EXCEPTION";
    public static final String ERROR_BUILDING_CLIENT_RESPONSE = "An error occurred building the client response, Exception: EXCEPTION";
    public static final String ERROR_PROCESSING_RESPONSE = "An error occurred processing the response";
    public static final String CONTACT_HELP_DESK = "contact help desk: 1-888-596-HELP (4357).^^^207~Application internal error~HL7 Table 0357\n";
    public static final String ERROR_ELEMENT_NAME = "error";
    public static final String REQUEST_ELEMENT_NAME = "request";
    public static final String RESPONSE_ROOT_ELEMENT_NAME = "response";
    protected static final String XP_ENTRYPOINT = "transformer/rpcbroker[@type='HL7' and @encoding='ER7']/entry-point[@code='WHAT_CODE']";
    protected static final String ERROR_WHAT_CODE = "ERROR";
    protected static final String XP_IGNORE_PROPERTY = "ignore";
    protected static final String STYLESHEET = "stylesheet";
    protected PropertyElement entryPoint = null;
    protected CommandFactory commandFactory = null;
    protected Command command = null;
    protected PropertyMgr propertyMgr = null;
    protected Document requestDocument = null;
    protected String queryTag = null;
    protected String whatCode = null;
    protected String originalMessageControlId = null;
    protected String sendingApplication = null;
    protected String sendingFacility = null;
    protected String receivingApplication = null;
    protected String receivingFacility = null;
    protected String message = null;
    protected String requestMessageDelimiters = null;
    protected StringBuffer workBuffer = new StringBuffer();
    protected boolean continueProcessing = true;
    protected String response = "";
    protected Object queryResults = null;

    protected abstract void initializeClientResponse() throws Exception;

    protected abstract ByteBuffer handleUnusableRequestError(Exception var1);

    protected abstract void handleCommandCreationError();

    protected abstract void handleCommandExecutionError(Exception var1);

    protected abstract String buildClientResponse(Object var1) throws Exception;

    protected abstract String buildClientNoOpResponse();

    protected abstract void handleBuildClientResponseError(Exception var1);

    protected void initialize(ER7RequestBroker aER7RequestBroker) {
        if (aER7RequestBroker != null) {
            this.propertyMgr = aER7RequestBroker.getPropertyMgr();
            this.requestDocument = aER7RequestBroker.getRequestDocument();
            this.sendingApplication = aER7RequestBroker.getSendingApplication();
            this.sendingFacility = aER7RequestBroker.getSendingFacility();
            this.receivingApplication = aER7RequestBroker.getReceivingApplication();
            this.receivingFacility = aER7RequestBroker.getReceivingFacility();
            this.whatCode = aER7RequestBroker.getWhatCode();
            this.originalMessageControlId = aER7RequestBroker.getOriginalMessageControlId();
            this.queryTag = aER7RequestBroker.getQueryTag();
            this.message = aER7RequestBroker.getMessage();
            this.workBuffer.setLength(0);
            this.workBuffer.append(HL7MessageInfoImpl.getFieldDelimeter((String)this.message));
            this.workBuffer.append(HL7MessageInfoImpl.getComponentSeparator((String)this.message));
            this.workBuffer.append(HL7MessageInfoImpl.getRepetitionSeparator((String)this.message));
            this.workBuffer.append(HL7MessageInfoImpl.getEscapeCharacter((String)this.message));
            this.workBuffer.append(HL7MessageInfoImpl.getSubcomponentSeparator((String)this.message));
            this.requestMessageDelimiters = this.workBuffer.toString();
        }
    }

    protected Command getCommand() throws Exception {
        this.commandFactory = CommandFactory.getInstance();
        this.command = this.commandFactory.createCommand(this.entryPoint);
        return this.command;
    }

    protected void buildResponseHeader(String aHeaderType, String aMessageType, String aVersion) throws MessageParserException {
        this.workBuffer.append(aHeaderType);
        this.workBuffer.append(HL7_DELIMITERS);
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.receivingApplication, (String)HL7_DELIMITERS));
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.receivingFacility, (String)HL7_DELIMITERS));
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.sendingApplication, (String)HL7_DELIMITERS));
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.sendingFacility, (String)HL7_DELIMITERS));
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(DateTimeUtility.getCurrentTime());
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(aMessageType);
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(System.currentTimeMillis());
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append("T");
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(aVersion);
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.appendHL7FieldSeparators(this.workBuffer, 4);
        this.workBuffer.append("USA");
        this.workBuffer.append(HL7_SEGMENT_SEPARATOR);
    }

    protected ByteBuffer invoke() {
        this.entryPoint = this.propertyMgr.getProperty(XP_ENTRYPOINT.replaceFirst(WHAT_CODE, this.whatCode));
        return this.invoke(this.entryPoint);
    }

    protected ByteBuffer invoke(PropertyElement aEntryPoint) {
        try {
            this.initializeClientResponse();
            this.entryPoint = aEntryPoint;
            this.command = this.getCommand();
        }
        catch (Exception e) {
            this.logIMSException("An error occurred creating the command object, Entry point: WHAT_CODE.\n", e, this.getClass().getName(), ErrorCode.SRVR_004);
            this.handleCommandCreationError();
            this.continueProcessing = false;
        }
        if (this.continueProcessing) {
            try {
                this.queryResults = this.command.execute(this.requestDocument);
            }
            catch (Exception e) {
                this.logIMSException("An error occurred during the execution of the command object, Exception: EXCEPTION.\n", e, this.getClass().getName(), ErrorCode.SRVR_005);
                this.handleCommandExecutionError(e);
            }
        }
        try {
            this.response = this.entryPoint.getChildProperties(XP_IGNORE_PROPERTY).length == 0 ? (this.queryResults != null ? this.buildClientResponse(this.queryResults) : this.workBuffer.toString()) : this.buildClientNoOpResponse();
        }
        catch (Exception e) {
            this.logIMSException("An error occurred processing the response.\n", e, this.getClass().getName(), ErrorCode.SRVR_006);
            this.handleBuildClientResponseError(e);
            this.response = this.workBuffer.toString();
        }
        return ByteBuffer.wrap(this.response.getBytes());
    }

    protected void appendHL7FieldSeparators(StringBuffer aStringBuffer, int aFieldSeparatorCount) {
        this.appendMultipleStringsToBuffer(HL7_FIELD_SEPARATOR, aStringBuffer, aFieldSeparatorCount);
    }

    protected void appendHL7ComponentSeparators(StringBuffer aStringBuffer, int aComponentSeparatorCount) {
        this.appendMultipleStringsToBuffer(HL7_COMPONENT_SEPARATOR, aStringBuffer, aComponentSeparatorCount);
    }

    protected void appendHL7SubComponentSeparators(StringBuffer aStringBuffer, int aSubComponentSeparatorCount) {
        this.appendMultipleStringsToBuffer(HL7_SUBCOMPONENT_SEPARATOR, aStringBuffer, aSubComponentSeparatorCount);
    }

    protected void appendHL7RepeatingFieldSeparators(StringBuffer aStringBuffer, int aRepeatingFieldSeparatorCount) {
        this.appendMultipleStringsToBuffer(HL7_REPEATING_FIELD_SEPARATOR, aStringBuffer, aRepeatingFieldSeparatorCount);
    }

    protected void appendMultipleStringsToBuffer(String aStringToAppend, StringBuffer aStringBuffer, int aCount) {
        for (int i = 0; i < aCount; ++i) {
            aStringBuffer.append(aStringToAppend);
        }
    }

    protected void logIMSException(String aMessage, Exception aException, String aClass, ErrorCode aErrorCode) {
        IMSException.getIMSException(aMessage, aException, aException.getMessage(), aClass, aErrorCode, new String[]{this.whatCode, this.originalMessageControlId, this.sendingApplication, this.receivingApplication});
    }

    protected void addMSASegmentToBuffer(StringBuffer aStringBuffer, String aMessageControlId, String aErrorMessage) {
        aStringBuffer.append(MESSAGE_ACKNOWLEDGMENT_SEGMENT);
        aStringBuffer.append(HL7_FIELD_SEPARATOR);
        aStringBuffer.append(ACKNOWLEDGMENT_CODE_APPLICATION_ERROR);
        aStringBuffer.append(HL7_FIELD_SEPARATOR);
        aStringBuffer.append(aMessageControlId);
        aStringBuffer.append(HL7_FIELD_SEPARATOR);
        aStringBuffer.append(aErrorMessage);
    }

    protected void addERRSegmentToBuffer(StringBuffer aStringBuffer, boolean aAddErrorSegmentCode, String aErrorCodeID, String aErrorMessage) {
        if (aAddErrorSegmentCode) {
            aStringBuffer.append(ERROR_SEGMENT);
        }
        aStringBuffer.append(HL7_FIELD_SEPARATOR);
        aStringBuffer.append(FIXED_ERROR_SEGMENT_ID);
        aStringBuffer.append(HL7_COMPONENT_SEPARATOR);
        this.appendHL7ComponentSeparators(aStringBuffer, 2);
        aStringBuffer.append(aErrorCodeID);
        aStringBuffer.append(HL7_SUBCOMPONENT_SEPARATOR);
        aStringBuffer.append(aErrorMessage);
        aStringBuffer.append(HL7_SUBCOMPONENT_SEPARATOR);
        aStringBuffer.append(HL7_ERROR_CODE_TABLE_ID);
    }
}

