/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.broker;

import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.xslt.XSLTAdapterFactory;
import gov.va.med.hds.hdr.common.rpc.broker.CHDRClientBroker;
import gov.va.med.hds.hdr.common.rpc.response.CHDRRelationalResponseObject;
import gov.va.med.hds.hdr.transformer.adapter.hl7er7.DefaultResultAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;

public class CHDRRelationalClientBroker
extends CHDRClientBroker {
    public static final String ERRORS_ELEMENT_NAME = "errors";

    protected String buildClientResponse(Object aQueryResults) throws Exception {
        String data = null;
        CHDRRelationalResponseObject cHDRResponseObject = (CHDRRelationalResponseObject)aQueryResults;
        ArrayList errors = cHDRResponseObject.getErrors();
        HashMap observations = (HashMap)cHDRResponseObject.getRelationalObservations();
        int errorsCount = 0;
        Iterator iter = observations.keySet().iterator();
        Document resultDocument = null;
        String transformedData = null;
        if (errors != null && (errorsCount = errors.size()) > 0) {
            this.workBuffer.append("ERR");
            for (int i = 0; i < errorsCount - 1; ++i) {
                this.addERRSegmentToBuffer(this.workBuffer, false, "207", (String)errors.get(i));
                this.workBuffer.append(HL7_REPEATING_FIELD_SEPARATOR);
            }
            this.addERRSegmentToBuffer(this.workBuffer, false, "207", (String)errors.get(errorsCount - 1));
            this.workBuffer.append("\n");
        }
        this.workBuffer.append(this.qpdSegment).append("\n");
        this.workBuffer.append(this.rcpSegment).append("\n");
        while (iter.hasNext()) {
            String key = (String)iter.next();
            resultDocument = (Document)observations.get(key);
            String template = this.entryPoint.getChildProperties("stylesheet")[0].getValue();
            Adapter adapter = new XSLTAdapterFactory(template).createAdapter();
            adapter.setInput(resultDocument);
            adapter.adapt();
            transformedData = (String)adapter.getResult();
            this.workBuffer.append(transformedData).append("\n");
        }
        this.hL7MessageCount = DefaultResultAdapter.getSegmentCount(this.workBuffer.toString(), "MSH");
        this.workBuffer.append("BTS").append(HL7_FIELD_SEPARATOR).append(this.hL7MessageCount);
        data = this.workBuffer.toString();
        return data;
    }
}

