/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.broker;

import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.common.rpc.broker.ClientRequestBroker;
import gov.va.med.hds.hdr.common.rpc.response.CHDRResponseObject;
import gov.va.med.hds.hdr.hl7.HL7DelimiterEncoder;
import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import gov.va.med.hds.hdr.transformer.adapter.hl7er7.DefaultResultAdapter;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CHDRClientBroker
extends ClientRequestBroker {
    public static final String BATCH_HEADER_SEGMENT = "BHS";
    public static final String BATCH_TRAILER_SEGMENT = "BTS";
    public static final String QUERY_PARAMETER_DEFINITION = "QPD";
    public static final String RESPONSE_CONTROL_PARAMETER = "RCP";
    public static final int NO_MESSAGES_RETURNED_COUNT = 0;
    public static final String BATCH_NAME_ID_TYPE = "RSP" + HL7_COMPONENT_SEPARATOR + "Z98" + HL7_COMPONENT_SEPARATOR + "QRY_Q01";
    public static final String ERROR_BUILDING_RESPONSE = "CHDRClientBroker response build exception: EXCEPTION ";
    protected String qpdSegment = null;
    protected String rcpSegment = null;
    protected int hL7MessageCount = 0;

    protected void initializeClientResponse() throws MessageParserException {
        this.workBuffer.setLength(0);
        this.buildResponseHeader(BATCH_HEADER_SEGMENT, BATCH_NAME_ID_TYPE, "");
        this.qpdSegment = DefaultResultAdapter.getFirstSegmentOccurence(this.message, QUERY_PARAMETER_DEFINITION);
        this.rcpSegment = DefaultResultAdapter.getFirstSegmentOccurence(this.message, RESPONSE_CONTROL_PARAMETER);
        if (!this.requestMessageDelimiters.equals("^~|\\&")) {
            this.qpdSegment = HL7DelimiterEncoder.reDelimitHL7StringWithNewDelimiters((String)this.qpdSegment, (String)this.requestMessageDelimiters, (String)"^~|\\&");
            this.rcpSegment = HL7DelimiterEncoder.reDelimitHL7StringWithNewDelimiters((String)this.rcpSegment, (String)this.requestMessageDelimiters, (String)"^~|\\&");
        }
    }

    protected ByteBuffer handleUnusableRequestError(Exception aException) {
        String errorMessage = "An error occurred parsing the client request, Exception: EXCEPTION".replaceFirst("EXCEPTION", aException.getMessage());
        this.addErrorResponseToBuffer(this.workBuffer, "207", errorMessage, 0);
        return ByteBuffer.wrap(this.workBuffer.toString().getBytes());
    }

    protected void handleCommandCreationError() {
        String errorMessage = "An error occurred creating the command object, Entry point: WHAT_CODE".replaceFirst("WHAT_CODE", this.whatCode);
        this.addErrorResponseToBuffer(this.workBuffer, "100", errorMessage, 0);
    }

    protected void handleCommandExecutionError(Exception aException) {
        String errorMessage = "An error occurred during the execution of the command object, Exception: EXCEPTION".replaceFirst("EXCEPTION", aException.getMessage());
        this.addErrorResponseToBuffer(this.workBuffer, "207", errorMessage, 0);
    }

    protected void handleBuildClientResponseError(Exception e) {
        String errorMessage = ERROR_BUILDING_RESPONSE.replaceFirst("EXCEPTION", e.getMessage());
        this.addErrorResponseToBuffer(this.workBuffer, "207", errorMessage, this.hL7MessageCount);
    }

    private void addErrorResponseToBuffer(StringBuffer aStringBuffer, String aErrorCodeID, String aErrorMessage, int aMessageCount) {
        this.addERRSegmentToBuffer(aStringBuffer, true, aErrorCodeID, aErrorMessage);
        aStringBuffer.append("\n");
        aStringBuffer.append(this.qpdSegment).append("\n");
        aStringBuffer.append(this.rcpSegment).append("\n");
        aStringBuffer.append(BATCH_TRAILER_SEGMENT).append(HL7_FIELD_SEPARATOR).append(aMessageCount).append("\n");
    }

    protected String buildClientResponse(Object aQueryResults) throws Exception {
        CHDRResponseObject cHDRResponseObject = (CHDRResponseObject)aQueryResults;
        ArrayList errors = cHDRResponseObject.getErrors();
        String observations = cHDRResponseObject.getObservations();
        int errorsCount = 0;
        if (errors != null && (errorsCount = errors.size()) > 0) {
            this.workBuffer.append("ERR");
            for (int i = 0; i < errorsCount - 1; ++i) {
                this.addERRSegmentToBuffer(this.workBuffer, false, "207", (String)errors.get(i));
                this.workBuffer.append(HL7_REPEATING_FIELD_SEPARATOR);
            }
            this.addERRSegmentToBuffer(this.workBuffer, false, "207", (String)errors.get(errorsCount - 1));
            this.workBuffer.append("\n");
        }
        this.workBuffer.append(this.qpdSegment).append("\n");
        this.workBuffer.append(this.rcpSegment);
        this.workBuffer.append(observations).append("\n");
        this.hL7MessageCount = DefaultResultAdapter.getSegmentCount(observations, "MSH");
        this.workBuffer.append(BATCH_TRAILER_SEGMENT).append(HL7_FIELD_SEPARATOR).append(this.hL7MessageCount);
        return this.workBuffer.toString();
    }

    protected String buildClientNoOpResponse() {
        return "";
    }

    protected void buildResponseHeader(String aHeaderType, String aBatchNameIdType, String aComment) throws MessageParserException {
        this.workBuffer.setLength(0);
        this.workBuffer.append(aHeaderType);
        this.workBuffer.append("^~|\\&").append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.receivingApplication, (String)"^~|\\&")).append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.receivingFacility, (String)"^~|\\&")).append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.sendingApplication, (String)"^~|\\&")).append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7DelimiterEncoder.encodeHL7Delimiters((String)this.sendingFacility, (String)"^~|\\&")).append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(DateTimeUtility.getCurrentTime()).append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(aBatchNameIdType).append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(aComment).append("\n");
    }
}

