/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.rpc.broker;

import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.xslt.XSLTAdapterFactory;
import gov.va.med.hds.hdr.common.rpc.broker.ClientRequestBroker;
import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import java.nio.ByteBuffer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CDSDefaultClientBroker
extends ClientRequestBroker {
    public static final String QUERY_ACKNOWLEDGMENT_SEGMENT = "QAK";
    public static final String TABLE_ROW_DEFINITION_SEGMENT = "RDF";
    public static final String RDF_SEGMENT_FIELD_COUNT = "1";
    public static final String QUERY_RESPONSE_STATUS = "OK";
    public static final String MESSAGE_IGNORED = "Message Ignored\n";
    public static final String MESSAGE_DATE_TIME_ELEMENT_NAME = "messageDateTime";
    public static final String MESSAGE_CONTROL_ID_ELEMENT_NAME = "messageControlId";
    public static final String CDS_HL7_VERSION = "2.3.1";
    protected String messageType = null;
    protected Document queryResultsDocument = null;
    protected Document responseDocument = null;
    protected Attribute attribute = null;
    protected Element messageDateTime = null;
    protected Element messageControlId = null;
    protected Element requestElement = null;
    protected Element errorElement = null;
    protected String templateName = null;

    protected void initializeClientResponse() throws MessageParserException {
        this.workBuffer.setLength(0);
        this.buildResponseHeader("MSH", "TBR~R08", CDS_HL7_VERSION);
    }

    protected ByteBuffer handleUnusableRequestError(Exception aException) {
        String exceptionMessage = aException.getMessage();
        if (null == exceptionMessage) {
            exceptionMessage = "";
        }
        String errorMessage = "An error occurred parsing the client request, Exception: EXCEPTION".replaceFirst("EXCEPTION", exceptionMessage);
        this.addMSASegmentToBuffer(this.workBuffer, this.originalMessageControlId, errorMessage);
        this.workBuffer.append("\n");
        this.addERRSegmentToBuffer(this.workBuffer, true, "207", errorMessage);
        this.workBuffer.append("\n");
        this.addQAKSegmentToBuffer(this.workBuffer, this.queryTag, QUERY_RESPONSE_STATUS);
        this.workBuffer.append("\n");
        this.addRDFSegmentToBuffer(this.workBuffer, RDF_SEGMENT_FIELD_COUNT);
        this.workBuffer.append("\n");
        return ByteBuffer.wrap(this.workBuffer.toString().getBytes());
    }

    protected void handleCommandCreationError() {
        this.buildErrorResponse("An error occurred creating the command object, Entry point: WHAT_CODE".replaceFirst("WHAT_CODE", this.whatCode), "AE");
    }

    protected void handleCommandExecutionError(Exception aException) {
        String exceptionMessage = aException.getMessage();
        if (null == exceptionMessage) {
            exceptionMessage = "";
        }
        String errorMessage = "An error occurred during the execution of the command object, Exception: EXCEPTION".replaceFirst("EXCEPTION", exceptionMessage);
        this.buildErrorResponse(errorMessage, "AR");
    }

    protected void buildErrorResponse(String aErrorMessage, String aAcknowledgmentCode) {
        this.errorElement = DocumentHelper.createElement((String)"error");
        this.errorElement.setText(aErrorMessage);
        this.errorElement.addAttribute("AckCode", aAcknowledgmentCode);
        this.queryResultsDocument = DocumentHelper.createDocument((Element)this.errorElement);
        this.queryResults = this.queryResultsDocument;
        this.entryPoint = this.propertyMgr.getProperty("transformer/rpcbroker[@type='HL7' and @encoding='ER7']/entry-point[@code='WHAT_CODE']".replaceFirst("WHAT_CODE", "ERROR"));
    }

    protected String buildClientResponse(Object aQueryResults) throws Exception {
        String returnValue = "";
        this.queryResultsDocument = (Document)aQueryResults;
        this.responseDocument = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"response"));
        this.messageDateTime = DocumentHelper.createElement((String)MESSAGE_DATE_TIME_ELEMENT_NAME);
        this.messageDateTime.setText(DateTimeUtility.getCurrentTime());
        this.responseDocument.getRootElement().add(this.messageDateTime);
        this.messageControlId = DocumentHelper.createElement((String)MESSAGE_CONTROL_ID_ELEMENT_NAME);
        this.messageControlId.setText(System.currentTimeMillis() + "");
        this.responseDocument.getRootElement().add(this.messageControlId);
        if (this.requestDocument != null) {
            this.requestElement = (Element)this.requestDocument.getRootElement().detach();
            this.requestElement.setName("request");
            this.responseDocument.getRootElement().add(this.requestElement);
        }
        this.responseDocument.getRootElement().add(this.queryResultsDocument.getRootElement().detach());
        String template = this.entryPoint.getChildProperties("stylesheet")[0].getValue();
        Adapter adapter = new XSLTAdapterFactory(template).createAdapter();
        adapter.setInput(this.responseDocument);
        adapter.adapt();
        returnValue = (String)adapter.getResult();
        return returnValue;
    }

    protected String buildClientNoOpResponse() {
        this.addMSASegmentToBuffer(this.workBuffer, this.originalMessageControlId, MESSAGE_IGNORED);
        this.workBuffer.append("\n");
        this.addQAKSegmentToBuffer(this.workBuffer, this.queryTag, QUERY_RESPONSE_STATUS);
        this.workBuffer.append("\n");
        this.addRDFSegmentToBuffer(this.workBuffer, RDF_SEGMENT_FIELD_COUNT);
        this.workBuffer.append("\n");
        return this.workBuffer.toString();
    }

    protected void handleBuildClientResponseError(Exception aException) {
        String exceptionMessage = aException.getMessage();
        if (null == exceptionMessage) {
            exceptionMessage = "";
        }
        String errorMessage = "An error occurred building the client response, Exception: EXCEPTION".replaceFirst("EXCEPTION", exceptionMessage);
        this.addMSASegmentToBuffer(this.workBuffer, this.originalMessageControlId, errorMessage);
        this.workBuffer.append("\n");
        this.addERRSegmentToBuffer(this.workBuffer, true, "207", errorMessage);
        this.workBuffer.append("\n");
        this.addQAKSegmentToBuffer(this.workBuffer, this.queryTag, QUERY_RESPONSE_STATUS);
        this.workBuffer.append("\n");
        this.addRDFSegmentToBuffer(this.workBuffer, RDF_SEGMENT_FIELD_COUNT);
        this.workBuffer.append("\n");
        this.response = this.workBuffer.toString();
    }

    protected void addQAKSegmentToBuffer(StringBuffer aStringBuffer, String aQueryTag, String aResponseStatus) {
        aStringBuffer.append(QUERY_ACKNOWLEDGMENT_SEGMENT).append(HL7_FIELD_SEPARATOR);
        aStringBuffer.append(aQueryTag).append(HL7_FIELD_SEPARATOR);
        aStringBuffer.append(aResponseStatus);
    }

    protected void addRDFSegmentToBuffer(StringBuffer aStringBuffer, String aSegmentFieldCount) {
        this.workBuffer.append(TABLE_ROW_DEFINITION_SEGMENT).append(HL7_FIELD_SEPARATOR);
        this.workBuffer.append(aSegmentFieldCount).append(HL7_FIELD_SEPARATOR);
    }
}

