/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.net;

import gov.va.med.hds.hdr.nio.protocol.MllpProtocolEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class MllpNetworkClient {
    private static final byte SEGMENT_DELIMETER = 13;
    private static final byte SOB = 11;
    private static final byte EOB = 28;
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static MllpNetworkClient instance = new MllpNetworkClient();

    private MllpNetworkClient() {
    }

    public static MllpNetworkClient getInstance() {
        return instance;
    }

    public String doRequest(String rawMessage, String host, int port, long timeout) throws Exception {
        String mllpMessage = MllpNetworkClient.mllpEncode(rawMessage);
        Socket s = null;
        SocketOpener so = new SocketOpener(host, port);
        Thread t = new Thread(so);
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException e) {
            throw new SocketException("Failed to create socket within with timeout (" + timeout + " ms) time.");
        }
        s = so.getSocket();
        if (s != null) {
            s.setSoTimeout((int)timeout);
            PrintStream ps = new PrintStream(s.getOutputStream(), true);
            ps.write(mllpMessage.getBytes());
            String reply = this.decodeMllpInput(s.getInputStream());
            s.close();
            return reply;
        }
        throw new Exception("A connection to the host could not be made.");
    }

    public String doRequest(String rawMessage, String host, int port) throws Exception {
        return this.doRequest(rawMessage, host, port, 30000L);
    }

    public static String mllpEncode(String rawMessage) throws IOException {
        MllpProtocolEncoder encoder = new MllpProtocolEncoder();
        return new String(encoder.encode(ByteBuffer.wrap(rawMessage.getBytes())).array());
    }

    private String decodeMllpInput(InputStream in) throws IOException {
        StringBuffer sbInput = new StringBuffer();
        boolean foundSob = false;
        Object line = null;
        int next = -1;
        while ((next = in.read()) != -1) {
            if (sbInput.length() == 0 && (next == 10 || next == 13)) continue;
            if (next == 11) {
                foundSob = true;
                continue;
            }
            if (next == 28) {
                foundSob = false;
                break;
            }
            if (next == 10) {
                next = 13;
            }
            if (!foundSob) continue;
            sbInput.append((char)next);
        }
        return sbInput.toString();
    }

    private class SocketOpener
    implements Runnable {
        private Socket s = null;
        private String host = null;
        private int port = 0;
        private Exception exception = null;

        public SocketOpener(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public void run() {
            try {
                this.s = new Socket(this.host, this.port);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public Socket getSocket() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.s;
        }
    }
}

